/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TypeUtils {
    public static int toSqlType(String clickshouseType) {
        if (TypeUtils.isNullable(clickshouseType)) {
            clickshouseType = TypeUtils.unwrapNullable(clickshouseType);
        }
        if (clickshouseType.startsWith("Int") || clickshouseType.startsWith("UInt")) {
            return clickshouseType.endsWith("64") ? -5 : 4;
        }
        if ("String".equals(clickshouseType)) {
            return 12;
        }
        if (clickshouseType.startsWith("Float32")) {
            return 6;
        }
        if (clickshouseType.startsWith("Float64")) {
            return 8;
        }
        if ("Date".equals(clickshouseType)) {
            return 91;
        }
        if ("DateTime".equals(clickshouseType)) {
            return 93;
        }
        if ("FixedString".equals(clickshouseType)) {
            return 2004;
        }
        if (TypeUtils.isArray(clickshouseType)) {
            return 2003;
        }
        return 12;
    }

    private static String unwrapNullable(String clickshouseType) {
        return clickshouseType.substring("Nullable(".length(), clickshouseType.length() - 1);
    }

    private static boolean isNullable(String clickshouseType) {
        return clickshouseType.startsWith("Nullable(") && clickshouseType.endsWith(")");
    }

    public static boolean isUnsigned(String clickhouseType) {
        if (TypeUtils.isNullable(clickhouseType)) {
            clickhouseType = TypeUtils.unwrapNullable(clickhouseType);
        }
        return clickhouseType.startsWith("UInt");
    }

    public static int[] supportedTypes() {
        return new int[]{-5, 4, 12, 6, 91, 93, 2004, 2003};
    }

    public static String getArrayElementTypeName(String clickhouseType) {
        if (!TypeUtils.isArray(clickhouseType)) {
            throw new IllegalArgumentException("not an array");
        }
        return clickhouseType.substring("Array(".length(), clickhouseType.length() - 1);
    }

    private static boolean isArray(String clickhouseType) {
        return clickhouseType.startsWith("Array(") && clickhouseType.endsWith(")");
    }

    public static Class toClass(int sqlType, boolean isUnsigned) throws SQLException {
        return TypeUtils.toClass(sqlType, -1, isUnsigned);
    }

    public static Class toClass(int sqlType, int elementSqltype, boolean isUnsigned) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                if (isUnsigned) {
                    return Long.class;
                }
                return Integer.class;
            }
            case -5: {
                if (isUnsigned) {
                    return BigInteger.class;
                }
                return Long.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2004: {
                return String.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 91: {
                return Date.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 2003: {
                Class elementType = TypeUtils.toClass(elementSqltype, isUnsigned);
                return Array.newInstance(elementType, 0).getClass();
            }
        }
        throw new UnsupportedOperationException("Sql type " + sqlType + "is not supported");
    }
}

