/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.yandex.clickhouse.util.ClickHouseCityHash;

public class ClickHouseBlockChecksum {
    private final long first;
    private final long second;

    public ClickHouseBlockChecksum(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public static ClickHouseBlockChecksum fromBytes(byte[] checksum) {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).put(checksum);
        buffer.flip();
        return new ClickHouseBlockChecksum(buffer.getLong(), buffer.getLong());
    }

    public static ClickHouseBlockChecksum calculateForBlock(byte magic, int compressedSizeWithHeader, int uncompressedSize, byte[] data, int length) {
        ByteBuffer buffer = ByteBuffer.allocate(compressedSizeWithHeader).order(ByteOrder.LITTLE_ENDIAN).put(magic).putInt(compressedSizeWithHeader).putInt(uncompressedSize).put(data, 0, length);
        buffer.flip();
        return ClickHouseBlockChecksum.calculate(buffer.array());
    }

    public byte[] asBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putLong(this.first).putLong(this.second);
        buffer.flip();
        return buffer.array();
    }

    private static ClickHouseBlockChecksum calculate(byte[] data) {
        long[] sum = ClickHouseCityHash.cityHash128(data, 0, data.length);
        return new ClickHouseBlockChecksum(sum[0], sum[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClickHouseBlockChecksum that = (ClickHouseBlockChecksum)o;
        if (this.first != that.first) {
            return false;
        }
        return this.second == that.second;
    }

    public int hashCode() {
        int result = (int)(this.first ^ this.first >>> 32);
        result = 31 * result + (int)(this.second ^ this.second >>> 32);
        return result;
    }

    public String toString() {
        return "{" + this.first + ", " + this.second + '}';
    }
}

