/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseExternalData;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.Jackson;
import ru.yandex.clickhouse.LZ4EntityWrapper;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.except.ClickHouseExceptionSpecifier;
import ru.yandex.clickhouse.response.ClickHouseLZ4Stream;
import ru.yandex.clickhouse.response.ClickHouseResponse;
import ru.yandex.clickhouse.response.ClickHouseResultSet;
import ru.yandex.clickhouse.response.FastByteArrayOutputStream;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.ClickHouseFormat;
import ru.yandex.clickhouse.util.ClickHouseStreamCallback;
import ru.yandex.clickhouse.util.ClickHouseStreamHttpEntity;
import ru.yandex.clickhouse.util.Patterns;
import ru.yandex.clickhouse.util.Utils;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class ClickHouseStatementImpl
implements ClickHouseStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    private final CloseableHttpClient client;
    protected ClickHouseProperties properties = new ClickHouseProperties();
    private ClickHouseConnection connection;
    private ClickHouseResultSet currentResult;
    private int currentUpdateCount = -1;
    private int queryTimeout;
    private int maxRows;
    private boolean closeOnCompletion;
    private final String initialDatabase;

    public ClickHouseStatementImpl(CloseableHttpClient client, ClickHouseConnection connection, ClickHouseProperties properties) {
        this.client = client;
        this.connection = connection;
        this.properties = properties;
        this.initialDatabase = properties.getDatabase();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQuery(sql, additionalDBParams, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        additionalDBParams = additionalDBParams == null ? new HashMap<ClickHouseQueryParam, String>() : new HashMap<ClickHouseQueryParam, String>(additionalDBParams);
        additionalDBParams.put(ClickHouseQueryParam.EXTREMES, "0");
        InputStream is = this.getInputStream(sql, additionalDBParams, externalData);
        try {
            if (ClickHouseStatementImpl.isSelect(sql)) {
                this.currentUpdateCount = -1;
                this.currentResult = new ClickHouseResultSet(this.properties.isCompress() ? new ClickHouseLZ4Stream(is) : is, this.properties.getBufferSize(), this.extractDBName(sql), this.extractTableName(sql), this.extractWithTotals(sql), this, this.getConnection().getTimeZone(), this.properties);
                this.currentResult.setMaxRows(this.maxRows);
                return this.currentResult;
            }
            this.currentUpdateCount = 0;
            StreamUtils.close(is);
            return null;
        }
        catch (Exception e) {
            StreamUtils.close(is);
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(String sql) throws SQLException {
        return this.executeQueryClickhouseResponse(sql, null);
    }

    @Override
    public ClickHouseResponse executeQueryClickhouseResponse(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        InputStream is = this.getInputStream(ClickHouseStatementImpl.addFormatIfAbsent(sql, "JSONCompact"), additionalDBParams, null);
        try {
            if (this.properties.isCompress()) {
                is = new ClickHouseLZ4Stream(is);
            }
            ClickHouseResponse clickHouseResponse = (ClickHouseResponse)Jackson.getObjectMapper().readValue(is, ClickHouseResponse.class);
            return clickHouseResponse;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            StreamUtils.close(is);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        InputStream is = null;
        try {
            is = this.getInputStream(sql, null, null);
        }
        catch (Throwable throwable) {
            StreamUtils.close(is);
            throw throwable;
        }
        StreamUtils.close(is);
        return 1;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return ClickHouseStatementImpl.isSelect(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException(String.format("Illegal maxRows value: %d", max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        this.currentUpdateCount = -1;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return new int[0];
    }

    @Override
    public ClickHouseConnection getConnection() throws ClickHouseException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    static String clickhousifySql(String sql) {
        return ClickHouseStatementImpl.addFormatIfAbsent(sql, "TabSeparatedWithNamesAndTypes");
    }

    private static String addFormatIfAbsent(String sql, String format) {
        sql = sql.trim();
        String woSemicolon = Patterns.SEMICOLON.matcher(sql).replaceAll("").trim();
        if (ClickHouseStatementImpl.isSelect(sql) && !woSemicolon.endsWith(" TabSeparatedWithNamesAndTypes") && !woSemicolon.endsWith(" TabSeparated") && !woSemicolon.endsWith(" JSONCompact")) {
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = sql + " FORMAT " + format + ';';
        }
        return sql;
    }

    private static boolean isSelect(String sql) {
        String upper = sql.toUpperCase().trim();
        return upper.startsWith("SELECT") || upper.startsWith("WITH") || upper.startsWith("SHOW") || upper.startsWith("DESC") || upper.startsWith("EXISTS");
    }

    private String extractTableName(String sql) {
        String s = this.extractDBAndTableName(sql);
        if (s.contains(".")) {
            return s.substring(s.indexOf(".") + 1);
        }
        return s;
    }

    private String extractDBName(String sql) {
        String s = this.extractDBAndTableName(sql);
        if (s.contains(".")) {
            return s.substring(0, s.indexOf("."));
        }
        return this.properties.getDatabase();
    }

    private String extractDBAndTableName(String sql) {
        if (Utils.startsWithIgnoreCase(sql, "select")) {
            String withoutStrings = Utils.retainUnquoted(sql, '\'');
            int fromIndex = withoutStrings.indexOf("from");
            if (fromIndex == -1) {
                fromIndex = withoutStrings.indexOf("FROM");
            }
            if (fromIndex != -1) {
                String fromFrom = withoutStrings.substring(fromIndex);
                String fromTable = fromFrom.substring("from".length()).trim();
                return fromTable.split(" ")[0];
            }
        }
        if (Utils.startsWithIgnoreCase(sql, "desc")) {
            return "system.columns";
        }
        if (Utils.startsWithIgnoreCase(sql, "show")) {
            return "system.tables";
        }
        return "system.unknown";
    }

    private boolean extractWithTotals(String sql) {
        if (Utils.startsWithIgnoreCase(sql, "select")) {
            String withoutStrings = Utils.retainUnquoted(sql, '\'');
            return withoutStrings.toLowerCase().contains(" with totals");
        }
        return false;
    }

    private InputStream getInputStream(String sql, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, List<ClickHouseExternalData> externalData) throws ClickHouseException {
        Object requestEntity;
        sql = ClickHouseStatementImpl.clickhousifySql(sql);
        log.debug("Executing SQL: " + sql);
        boolean ignoreDatabase = sql.toUpperCase().startsWith("CREATE DATABASE");
        URI uri = externalData == null || externalData.isEmpty() ? this.buildRequestUri(null, null, additionalClickHouseDBParams, ignoreDatabase) : this.buildRequestUri(sql, externalData, additionalClickHouseDBParams, ignoreDatabase);
        log.debug("Request url: " + uri);
        HttpPost post = new HttpPost(uri);
        if (externalData == null || externalData.isEmpty()) {
            requestEntity = new StringEntity(sql, StreamUtils.UTF_8);
        } else {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            try {
                for (ClickHouseExternalData externalDataItem : externalData) {
                    entityBuilder.addBinaryBody(externalDataItem.getName(), StreamUtils.toByteArray(externalDataItem.getContent()), ContentType.APPLICATION_OCTET_STREAM, externalDataItem.getName());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            requestEntity = entityBuilder.build();
        }
        if (this.properties.isDecompress()) {
            requestEntity = new LZ4EntityWrapper((HttpEntity)requestEntity, this.properties.getMaxCompressBufferSize());
        }
        post.setEntity((HttpEntity)requestEntity);
        HttpEntity entity = null;
        try {
            InputStream is;
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
            entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                InputStream messageStream = entity.getContent();
                byte[] bytes = StreamUtils.toByteArray(messageStream);
                if (this.properties.isCompress()) {
                    try {
                        messageStream = new ClickHouseLZ4Stream(new ByteArrayInputStream(bytes));
                        bytes = StreamUtils.toByteArray(messageStream);
                    }
                    catch (IOException e) {
                        log.warn("error while read compressed stream" + e.getMessage());
                    }
                }
                EntityUtils.consumeQuietly((HttpEntity)entity);
                String chMessage = new String(bytes, StreamUtils.UTF_8);
                throw ClickHouseExceptionSpecifier.specify(chMessage, this.properties.getHost(), this.properties.getPort());
            }
            if (entity.isStreaming()) {
                is = entity.getContent();
            } else {
                FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
                entity.writeTo((OutputStream)baos);
                is = baos.convertToInputStream();
            }
            return is;
        }
        catch (ClickHouseException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("Error during connection to " + this.properties + ", reporting failure to data source, message: " + e.getMessage());
            EntityUtils.consumeQuietly((HttpEntity)entity);
            log.info("Error sql: " + sql);
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    URI buildRequestUri(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, boolean ignoreDatabase) {
        try {
            List<NameValuePair> queryParams = this.getUrlQueryParams(sql, externalData, additionalClickHouseDBParams, ignoreDatabase);
            return new URIBuilder().setScheme(this.properties.getSsl() ? "https" : "http").setHost(this.properties.getHost()).setPort(this.properties.getPort()).setPath("/").setParameters(queryParams).build();
        }
        catch (URISyntaxException e) {
            log.error("Mailformed URL: " + e.getMessage());
            throw new IllegalStateException("illegal configuration of db");
        }
    }

    private List<NameValuePair> getUrlQueryParams(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, boolean ignoreDatabase) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (sql != null) {
            result.add((NameValuePair)new BasicNameValuePair("query", sql));
        }
        if (externalData != null) {
            for (ClickHouseExternalData externalDataItem : externalData) {
                String name = externalDataItem.getName();
                String format = externalDataItem.getFormat();
                String types = externalDataItem.getTypes();
                String structure = externalDataItem.getStructure();
                if (format != null && !format.isEmpty()) {
                    result.add((NameValuePair)new BasicNameValuePair(name + "_format", format));
                }
                if (types != null && !types.isEmpty()) {
                    result.add((NameValuePair)new BasicNameValuePair(name + "_types", types));
                }
                if (structure == null || structure.isEmpty()) continue;
                result.add((NameValuePair)new BasicNameValuePair(name + "_structure", structure));
            }
        }
        Map<ClickHouseQueryParam, String> params = this.properties.buildQueryParams(true);
        if (!ignoreDatabase) {
            params.put(ClickHouseQueryParam.DATABASE, this.initialDatabase);
        }
        if (additionalClickHouseDBParams != null && !additionalClickHouseDBParams.isEmpty()) {
            params.putAll(additionalClickHouseDBParams);
        }
        this.setStatementPropertiesToParams(params);
        for (Map.Entry<ClickHouseQueryParam, String> entry : params.entrySet()) {
            if (Strings.isNullOrEmpty((String)entry.getValue())) continue;
            result.add((NameValuePair)new BasicNameValuePair(entry.getKey().toString(), entry.getValue()));
        }
        return result;
    }

    private void setStatementPropertiesToParams(Map<ClickHouseQueryParam, String> params) {
        if (this.maxRows > 0) {
            params.put(ClickHouseQueryParam.MAX_RESULT_ROWS, String.valueOf(this.maxRows));
            params.put(ClickHouseQueryParam.RESULT_OVERFLOW_MODE, "break");
        }
    }

    @Override
    public void sendRowBinaryStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendStream((HttpEntity)new ClickHouseStreamHttpEntity(callback, this.getConnection().getTimeZone(), this.properties), sql, ClickHouseFormat.RowBinary);
    }

    @Override
    public void sendNativeStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendStream((HttpEntity)new ClickHouseStreamHttpEntity(callback, this.getConnection().getTimeZone(), this.properties), sql, ClickHouseFormat.Native);
    }

    @Override
    public void sendStream(InputStream content, String table) throws ClickHouseException {
        String query = "INSERT INTO " + table;
        this.sendStream((HttpEntity)new InputStreamEntity(content, -1L), query);
    }

    public void sendStream(HttpEntity content, String sql) throws ClickHouseException {
        this.sendStream(content, sql, ClickHouseFormat.TabSeparated);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendStream(HttpEntity content, String sql, ClickHouseFormat format) throws ClickHouseException {
        HttpEntity entity = null;
        try {
            URI uri = this.buildRequestUri(sql + " FORMAT " + format.name(), null, null, false);
            HttpPost httpPost = new HttpPost(uri);
            if (this.properties.isDecompress()) {
                httpPost.setEntity((HttpEntity)new LZ4EntityWrapper(content, this.properties.getMaxCompressBufferSize()));
            } else {
                httpPost.setEntity(content);
            }
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                String chMessage;
                try {
                    chMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                    throw ClickHouseExceptionSpecifier.specify(chMessage, this.properties.getHost(), this.properties.getPort());
                }
                catch (IOException e) {
                    chMessage = "error while read response " + e.getMessage();
                }
                throw ClickHouseExceptionSpecifier.specify(chMessage, this.properties.getHost(), this.properties.getPort());
            }
        }
        catch (ClickHouseException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw ClickHouseExceptionSpecifier.specify(e2, this.properties.getHost(), this.properties.getPort());
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(entity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)entity);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }
}

