/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.util.Collection;
import ru.yandex.clickhouse.ClickHouseUtil;

public class ClickHouseArrayUtil {
    private ClickHouseArrayUtil() {
    }

    public static String arrayToString(Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Object must be array");
        }
        if (object.getClass().getComponentType().isPrimitive()) {
            return ClickHouseArrayUtil.primitiveArrayToString(object);
        }
        return ClickHouseArrayUtil.toString((Object[])object);
    }

    private static String primitiveArrayToString(Object array) {
        if (array instanceof int[]) {
            return ClickHouseArrayUtil.toString((int[])array);
        }
        if (array instanceof long[]) {
            return ClickHouseArrayUtil.toString((long[])array);
        }
        if (array instanceof float[]) {
            return ClickHouseArrayUtil.toString((float[])array);
        }
        if (array instanceof double[]) {
            return ClickHouseArrayUtil.toString((double[])array);
        }
        if (array instanceof char[]) {
            return ClickHouseArrayUtil.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return ClickHouseArrayUtil.toString((byte[])array);
        }
        if (array instanceof short[]) {
            return ClickHouseArrayUtil.toString((short[])array);
        }
        throw new IllegalArgumentException("Wrong primitive type: " + array.getClass().getComponentType());
    }

    public static String toString(int[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (int value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(long[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (long value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(float[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (float value : values) {
            builder.append(Float.valueOf(value));
        }
        return builder.build();
    }

    public static String toString(double[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (double value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(byte[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (byte value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(short[] values) {
        ArrayBuilder builder = new ArrayBuilder(false);
        for (short value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(char[] values) {
        ArrayBuilder builder = new ArrayBuilder(true);
        for (char value : values) {
            builder.append(Character.valueOf(value));
        }
        return builder.build();
    }

    public static String toString(Object[] values) {
        if (values.length > 0 && (values[0].getClass().isArray() || values[0] instanceof Collection)) {
            ArrayBuilder builder = new ArrayBuilder(false);
            for (Object value : values) {
                if (value instanceof Collection) {
                    Object[] objects = ((Collection)value).toArray();
                    builder.append(ClickHouseArrayUtil.toString(objects));
                    continue;
                }
                builder.append(ClickHouseArrayUtil.arrayToString(value));
            }
            return builder.build();
        }
        ArrayBuilder builder = new ArrayBuilder(ClickHouseArrayUtil.needQuote(values));
        for (Object value : values) {
            builder.append(value);
        }
        return builder.build();
    }

    public static String toString(Collection collection) {
        return ClickHouseArrayUtil.toString(collection.toArray());
    }

    private static boolean needQuote(Object[] objects) {
        return objects.length == 0 || !(objects[0] instanceof Number);
    }

    private static class ArrayBuilder {
        private final StringBuilder builder = new StringBuilder();
        private final boolean quote;
        private int size = 0;
        private boolean built = false;

        private ArrayBuilder(boolean quote) {
            this.quote = quote;
            this.builder.append('[');
        }

        private ArrayBuilder append(Object value) {
            String serializedValue = value.toString();
            if (this.quote) {
                serializedValue = ClickHouseUtil.escape(serializedValue);
            }
            if (this.built) {
                throw new IllegalStateException("Already built");
            }
            if (this.size > 0) {
                this.builder.append(',');
            }
            if (this.quote) {
                this.builder.append('\'');
            }
            this.builder.append(serializedValue);
            if (this.quote) {
                this.builder.append('\'');
            }
            ++this.size;
            return this;
        }

        private String build() {
            if (!this.built) {
                this.builder.append(']');
                this.built = false;
            }
            return this.builder.toString();
        }
    }
}

