/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ru.yandex.clickhouse.settings.ClickHouseConnectionSettings;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.apache.StringUtils;

public class ClickHouseProperties {
    private boolean async;
    private int bufferSize;
    private int apacheBufferSize;
    private int socketTimeout;
    private int connectionTimeout;
    private int dataTransferTimeout;
    private int keepAliveTimeout;
    private int timeToLiveMillis;
    private int defaultMaxPerRoute;
    private int maxTotal;
    private String host;
    private int port;
    private boolean ssl;
    private String sslRootCertificate;
    private String sslMode;
    private int maxCompressBufferSize;
    private boolean useServerTimeZone;
    private String useTimeZone;
    private boolean useServerTimeZoneForDates;
    private boolean useObjectsInArrays;
    private Integer maxParallelReplicas;
    private String totalsMode;
    private String quotaKey;
    private Integer priority;
    private String database;
    private boolean compress;
    private boolean decompress;
    private boolean extremes;
    private Integer maxThreads;
    private Integer maxExecutionTime;
    private Integer maxBlockSize;
    private Integer maxRowsToGroupBy;
    private String profile;
    private String user;
    private String password;
    private boolean distributedAggregationMemoryEfficient;
    private Long maxBytesBeforeExternalGroupBy;
    private Long maxBytesBeforeExternalSort;
    private Long maxMemoryUsage;
    private Long preferredBlockSizeBytes;
    private Long maxQuerySize;
    private boolean sessionCheck;
    private String sessionId;
    private Long sessionTimeout;

    public ClickHouseProperties() {
        this(new Properties());
    }

    public ClickHouseProperties(Properties info) {
        this.async = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.ASYNC);
        this.bufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.BUFFER_SIZE);
        this.apacheBufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.APACHE_BUFFER_SIZE);
        this.socketTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.SOCKET_TIMEOUT);
        this.connectionTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.CONNECTION_TIMEOUT);
        this.dataTransferTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DATA_TRANSFER_TIMEOUT);
        this.keepAliveTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.KEEP_ALIVE_TIMEOUT);
        this.timeToLiveMillis = (Integer)this.getSetting(info, ClickHouseConnectionSettings.TIME_TO_LIVE_MILLIS);
        this.defaultMaxPerRoute = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DEFAULT_MAX_PER_ROUTE);
        this.maxTotal = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_TOTAL);
        this.maxCompressBufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_COMPRESS_BUFFER_SIZE);
        this.ssl = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.SSL);
        this.sslRootCertificate = (String)this.getSetting(info, ClickHouseConnectionSettings.SSL_ROOT_CERTIFICATE);
        this.sslMode = (String)this.getSetting(info, ClickHouseConnectionSettings.SSL_MODE);
        this.useServerTimeZone = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE);
        this.useTimeZone = (String)this.getSetting(info, ClickHouseConnectionSettings.USE_TIME_ZONE);
        this.useServerTimeZoneForDates = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE_FOR_DATES);
        this.useObjectsInArrays = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_OBJECTS_IN_ARRAYS);
        this.maxParallelReplicas = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_PARALLEL_REPLICAS);
        this.totalsMode = (String)this.getSetting(info, ClickHouseQueryParam.TOTALS_MODE);
        this.quotaKey = (String)this.getSetting(info, ClickHouseQueryParam.QUOTA_KEY);
        this.priority = (Integer)this.getSetting(info, ClickHouseQueryParam.PRIORITY);
        this.database = (String)this.getSetting(info, ClickHouseQueryParam.DATABASE);
        this.compress = (Boolean)this.getSetting(info, ClickHouseQueryParam.COMPRESS);
        this.decompress = (Boolean)this.getSetting(info, ClickHouseQueryParam.DECOMPRESS);
        this.extremes = (Boolean)this.getSetting(info, ClickHouseQueryParam.EXTREMES);
        this.maxThreads = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_THREADS);
        this.maxExecutionTime = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_EXECUTION_TIME);
        this.maxBlockSize = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_BLOCK_SIZE);
        this.maxRowsToGroupBy = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY);
        this.profile = (String)this.getSetting(info, ClickHouseQueryParam.PROFILE);
        this.user = (String)this.getSetting(info, ClickHouseQueryParam.USER);
        this.password = (String)this.getSetting(info, ClickHouseQueryParam.PASSWORD);
        this.distributedAggregationMemoryEfficient = (Boolean)this.getSetting(info, ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT);
        this.maxBytesBeforeExternalGroupBy = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY);
        this.maxBytesBeforeExternalSort = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT);
        this.maxMemoryUsage = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_MEMORY_USAGE);
        this.preferredBlockSizeBytes = (Long)this.getSetting(info, ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES);
        this.maxQuerySize = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_QUERY_SIZE);
        this.sessionCheck = (Boolean)this.getSetting(info, ClickHouseQueryParam.SESSION_CHECK);
        this.sessionId = (String)this.getSetting(info, ClickHouseQueryParam.SESSION_ID);
        this.sessionTimeout = (Long)this.getSetting(info, ClickHouseQueryParam.SESSION_TIMEOUT);
    }

    public Properties asProperties() {
        PropertiesBuilder ret = new PropertiesBuilder();
        ret.put(ClickHouseConnectionSettings.ASYNC.getKey(), String.valueOf(this.async));
        ret.put(ClickHouseConnectionSettings.BUFFER_SIZE.getKey(), String.valueOf(this.bufferSize));
        ret.put(ClickHouseConnectionSettings.APACHE_BUFFER_SIZE.getKey(), String.valueOf(this.apacheBufferSize));
        ret.put(ClickHouseConnectionSettings.SOCKET_TIMEOUT.getKey(), String.valueOf(this.socketTimeout));
        ret.put(ClickHouseConnectionSettings.CONNECTION_TIMEOUT.getKey(), String.valueOf(this.connectionTimeout));
        ret.put(ClickHouseConnectionSettings.DATA_TRANSFER_TIMEOUT.getKey(), String.valueOf(this.dataTransferTimeout));
        ret.put(ClickHouseConnectionSettings.KEEP_ALIVE_TIMEOUT.getKey(), String.valueOf(this.keepAliveTimeout));
        ret.put(ClickHouseConnectionSettings.TIME_TO_LIVE_MILLIS.getKey(), String.valueOf(this.timeToLiveMillis));
        ret.put(ClickHouseConnectionSettings.DEFAULT_MAX_PER_ROUTE.getKey(), String.valueOf(this.defaultMaxPerRoute));
        ret.put(ClickHouseConnectionSettings.MAX_TOTAL.getKey(), String.valueOf(this.maxTotal));
        ret.put(ClickHouseConnectionSettings.MAX_COMPRESS_BUFFER_SIZE.getKey(), String.valueOf(this.maxCompressBufferSize));
        ret.put(ClickHouseConnectionSettings.SSL.getKey(), String.valueOf(this.ssl));
        ret.put(ClickHouseConnectionSettings.SSL_ROOT_CERTIFICATE.getKey(), String.valueOf(this.sslRootCertificate));
        ret.put(ClickHouseConnectionSettings.SSL_MODE.getKey(), String.valueOf(this.sslMode));
        ret.put(ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE.getKey(), String.valueOf(this.useServerTimeZone));
        ret.put(ClickHouseConnectionSettings.USE_TIME_ZONE.getKey(), String.valueOf(this.useTimeZone));
        ret.put(ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE_FOR_DATES.getKey(), String.valueOf(this.useServerTimeZoneForDates));
        ret.put(ClickHouseConnectionSettings.USE_OBJECTS_IN_ARRAYS.getKey(), String.valueOf(this.useObjectsInArrays));
        ret.put(ClickHouseQueryParam.MAX_PARALLEL_REPLICAS.getKey(), this.maxParallelReplicas);
        ret.put(ClickHouseQueryParam.TOTALS_MODE.getKey(), this.totalsMode);
        ret.put(ClickHouseQueryParam.QUOTA_KEY.getKey(), this.quotaKey);
        ret.put(ClickHouseQueryParam.PRIORITY.getKey(), this.priority);
        ret.put(ClickHouseQueryParam.DATABASE.getKey(), this.database);
        ret.put(ClickHouseQueryParam.COMPRESS.getKey(), String.valueOf(this.compress));
        ret.put(ClickHouseQueryParam.DECOMPRESS.getKey(), String.valueOf(this.decompress));
        ret.put(ClickHouseQueryParam.EXTREMES.getKey(), String.valueOf(this.extremes));
        ret.put(ClickHouseQueryParam.MAX_THREADS.getKey(), this.maxThreads);
        ret.put(ClickHouseQueryParam.MAX_EXECUTION_TIME.getKey(), this.maxExecutionTime);
        ret.put(ClickHouseQueryParam.MAX_BLOCK_SIZE.getKey(), this.maxBlockSize);
        ret.put(ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY.getKey(), this.maxRowsToGroupBy);
        ret.put(ClickHouseQueryParam.PROFILE.getKey(), this.profile);
        ret.put(ClickHouseQueryParam.USER.getKey(), this.user);
        ret.put(ClickHouseQueryParam.PASSWORD.getKey(), this.password);
        ret.put(ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT.getKey(), String.valueOf(this.distributedAggregationMemoryEfficient));
        ret.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY.getKey(), this.maxBytesBeforeExternalGroupBy);
        ret.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT.getKey(), this.maxBytesBeforeExternalSort);
        ret.put(ClickHouseQueryParam.MAX_MEMORY_USAGE.getKey(), this.maxMemoryUsage);
        ret.put(ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES.getKey(), this.preferredBlockSizeBytes);
        ret.put(ClickHouseQueryParam.MAX_QUERY_SIZE.getKey(), this.maxQuerySize);
        ret.put(ClickHouseQueryParam.SESSION_CHECK.getKey(), String.valueOf(this.sessionCheck));
        ret.put(ClickHouseQueryParam.SESSION_ID.getKey(), this.sessionId);
        ret.put(ClickHouseQueryParam.SESSION_TIMEOUT.getKey(), this.sessionTimeout);
        return ret.getProperties();
    }

    public ClickHouseProperties(ClickHouseProperties properties) {
        this.setHost(properties.host);
        this.setPort(properties.port);
        this.setAsync(properties.async);
        this.setBufferSize(properties.bufferSize);
        this.setApacheBufferSize(properties.apacheBufferSize);
        this.setSocketTimeout(properties.socketTimeout);
        this.setConnectionTimeout(properties.connectionTimeout);
        this.setDataTransferTimeout(properties.dataTransferTimeout);
        this.setKeepAliveTimeout(properties.keepAliveTimeout);
        this.setTimeToLiveMillis(properties.timeToLiveMillis);
        this.setDefaultMaxPerRoute(properties.defaultMaxPerRoute);
        this.setMaxTotal(properties.maxTotal);
        this.setMaxCompressBufferSize(properties.maxCompressBufferSize);
        this.setSsl(properties.ssl);
        this.setSslRootCertificate(properties.sslRootCertificate);
        this.setSslMode(properties.sslMode);
        this.setUseServerTimeZone(properties.useServerTimeZone);
        this.setUseTimeZone(properties.useTimeZone);
        this.setUseServerTimeZoneForDates(properties.useServerTimeZoneForDates);
        this.setUseObjectsInArrays(properties.useObjectsInArrays);
        this.setMaxParallelReplicas(properties.maxParallelReplicas);
        this.setTotalsMode(properties.totalsMode);
        this.setQuotaKey(properties.quotaKey);
        this.setPriority(properties.priority);
        this.setDatabase(properties.database);
        this.setCompress(properties.compress);
        this.setDecompress(properties.decompress);
        this.setExtremes(properties.extremes);
        this.setMaxThreads(properties.maxThreads);
        this.setMaxExecutionTime(properties.maxExecutionTime);
        this.setMaxBlockSize(properties.maxBlockSize);
        this.setMaxRowsToGroupBy(properties.maxRowsToGroupBy);
        this.setProfile(properties.profile);
        this.setUser(properties.user);
        this.setPassword(properties.password);
        this.setDistributedAggregationMemoryEfficient(properties.distributedAggregationMemoryEfficient);
        this.setMaxBytesBeforeExternalGroupBy(properties.maxBytesBeforeExternalGroupBy);
        this.setMaxBytesBeforeExternalSort(properties.maxBytesBeforeExternalSort);
        this.setMaxMemoryUsage(properties.maxMemoryUsage);
        this.setSessionCheck(properties.sessionCheck);
        this.setSessionId(properties.sessionId);
        this.setSessionTimeout(properties.sessionTimeout);
        this.setPreferredBlockSizeBytes(properties.preferredBlockSizeBytes);
        this.setMaxQuerySize(properties.maxQuerySize);
    }

    public Map<ClickHouseQueryParam, String> buildQueryParams(boolean ignoreDatabase) {
        HashMap<ClickHouseQueryParam, String> params = new HashMap<ClickHouseQueryParam, String>();
        if (this.maxParallelReplicas != null) {
            params.put(ClickHouseQueryParam.MAX_PARALLEL_REPLICAS, String.valueOf(this.maxParallelReplicas));
        }
        if (this.maxRowsToGroupBy != null) {
            params.put(ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY, String.valueOf(this.maxRowsToGroupBy));
        }
        if (this.totalsMode != null) {
            params.put(ClickHouseQueryParam.TOTALS_MODE, this.totalsMode);
        }
        if (this.quotaKey != null) {
            params.put(ClickHouseQueryParam.QUOTA_KEY, this.quotaKey);
        }
        if (this.priority != null) {
            params.put(ClickHouseQueryParam.PRIORITY, String.valueOf(this.priority));
        }
        if (!StringUtils.isBlank(this.database) && !ignoreDatabase) {
            params.put(ClickHouseQueryParam.DATABASE, this.getDatabase());
        }
        if (this.compress) {
            params.put(ClickHouseQueryParam.COMPRESS, "1");
        }
        if (this.decompress) {
            params.put(ClickHouseQueryParam.DECOMPRESS, "1");
        }
        if (this.extremes) {
            params.put(ClickHouseQueryParam.EXTREMES, "1");
        }
        if (StringUtils.isBlank(this.profile)) {
            if (this.getMaxThreads() != null) {
                params.put(ClickHouseQueryParam.MAX_THREADS, String.valueOf(this.maxThreads));
            }
            if (this.getMaxExecutionTime() != null) {
                params.put(ClickHouseQueryParam.MAX_EXECUTION_TIME, String.valueOf(this.maxExecutionTime));
            }
            if (this.getMaxBlockSize() != null) {
                params.put(ClickHouseQueryParam.MAX_BLOCK_SIZE, String.valueOf(this.getMaxBlockSize()));
            }
        } else {
            params.put(ClickHouseQueryParam.PROFILE, this.profile);
        }
        if (this.user != null) {
            params.put(ClickHouseQueryParam.USER, this.user);
        }
        if (this.password != null) {
            params.put(ClickHouseQueryParam.PASSWORD, this.password);
        }
        if (this.distributedAggregationMemoryEfficient) {
            params.put(ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT, "1");
        }
        if (this.maxBytesBeforeExternalGroupBy != null) {
            params.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY, String.valueOf(this.maxBytesBeforeExternalGroupBy));
        }
        if (this.maxBytesBeforeExternalSort != null) {
            params.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT, String.valueOf(this.maxBytesBeforeExternalSort));
        }
        if (this.maxMemoryUsage != null) {
            params.put(ClickHouseQueryParam.MAX_MEMORY_USAGE, String.valueOf(this.maxMemoryUsage));
        }
        if (this.preferredBlockSizeBytes != null) {
            params.put(ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES, String.valueOf(this.preferredBlockSizeBytes));
        }
        if (this.maxQuerySize != null) {
            params.put(ClickHouseQueryParam.MAX_QUERY_SIZE, String.valueOf(this.maxQuerySize));
        }
        if (this.sessionCheck) {
            params.put(ClickHouseQueryParam.SESSION_CHECK, "1");
        }
        if (this.sessionId != null) {
            params.put(ClickHouseQueryParam.SESSION_ID, String.valueOf(this.sessionId));
        }
        if (this.sessionTimeout != null) {
            params.put(ClickHouseQueryParam.SESSION_TIMEOUT, String.valueOf(this.sessionTimeout));
        }
        return params;
    }

    public ClickHouseProperties withCredentials(String user, String password) {
        ClickHouseProperties copy = new ClickHouseProperties(this);
        copy.setUser(user);
        copy.setPassword(password);
        return copy;
    }

    private <T> T getSetting(Properties info, ClickHouseQueryParam param) {
        return this.getSetting(info, param.getKey(), param.getDefaultValue(), param.getClazz());
    }

    private <T> T getSetting(Properties info, ClickHouseConnectionSettings settings) {
        return this.getSetting(info, settings.getKey(), settings.getDefaultValue(), settings.getClazz());
    }

    private <T> T getSetting(Properties info, String key, Object defaultValue, Class clazz) {
        String val = info.getProperty(key);
        if (val == null) {
            return (T)defaultValue;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return clazz.cast(Integer.valueOf(val));
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return clazz.cast(Long.valueOf(val));
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            Boolean boolValue = "1".equals(val) || "0".equals(val) ? Boolean.valueOf("1".equals(val)) : Boolean.valueOf(val);
            return clazz.cast(boolValue);
        }
        return clazz.cast(val);
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isDecompress() {
        return this.decompress;
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(Integer maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getApacheBufferSize() {
        return this.apacheBufferSize;
    }

    public void setApacheBufferSize(int apacheBufferSize) {
        this.apacheBufferSize = apacheBufferSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getDataTransferTimeout() {
        return this.dataTransferTimeout;
    }

    public void setDataTransferTimeout(int dataTransferTimeout) {
        this.dataTransferTimeout = dataTransferTimeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    public void setTimeToLiveMillis(int timeToLiveMillis) {
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxCompressBufferSize() {
        return this.maxCompressBufferSize;
    }

    public void setMaxCompressBufferSize(int maxCompressBufferSize) {
        this.maxCompressBufferSize = maxCompressBufferSize;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSslRootCertificate() {
        return this.sslRootCertificate;
    }

    public void setSslRootCertificate(String sslRootCertificate) {
        this.sslRootCertificate = sslRootCertificate;
    }

    public String getSslMode() {
        return this.sslMode;
    }

    public void setSslMode(String sslMode) {
        this.sslMode = sslMode;
    }

    public boolean isUseServerTimeZone() {
        return this.useServerTimeZone;
    }

    public void setUseServerTimeZone(boolean useServerTimeZone) {
        this.useServerTimeZone = useServerTimeZone;
    }

    public String getUseTimeZone() {
        return this.useTimeZone;
    }

    public void setUseTimeZone(String useTimeZone) {
        this.useTimeZone = useTimeZone;
    }

    public boolean isUseObjectsInArrays() {
        return this.useObjectsInArrays;
    }

    public void setUseObjectsInArrays(boolean useObjectsInArrays) {
        this.useObjectsInArrays = useObjectsInArrays;
    }

    public boolean isUseServerTimeZoneForDates() {
        return this.useServerTimeZoneForDates;
    }

    public void setUseServerTimeZoneForDates(boolean useServerTimeZoneForDates) {
        this.useServerTimeZoneForDates = useServerTimeZoneForDates;
    }

    public Integer getMaxParallelReplicas() {
        return this.maxParallelReplicas;
    }

    public void setMaxParallelReplicas(Integer maxParallelReplicas) {
        this.maxParallelReplicas = maxParallelReplicas;
    }

    public String getTotalsMode() {
        return this.totalsMode;
    }

    public void setTotalsMode(String totalsMode) {
        this.totalsMode = totalsMode;
    }

    public String getQuotaKey() {
        return this.quotaKey;
    }

    public void setQuotaKey(String quotaKey) {
        this.quotaKey = quotaKey;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean isExtremes() {
        return this.extremes;
    }

    public void setExtremes(boolean extremes) {
        this.extremes = extremes;
    }

    public Integer getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(Integer maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public Integer getMaxRowsToGroupBy() {
        return this.maxRowsToGroupBy;
    }

    public void setMaxRowsToGroupBy(Integer maxRowsToGroupBy) {
        this.maxRowsToGroupBy = maxRowsToGroupBy;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isDistributedAggregationMemoryEfficient() {
        return this.distributedAggregationMemoryEfficient;
    }

    public void setDistributedAggregationMemoryEfficient(boolean distributedAggregationMemoryEfficient) {
        this.distributedAggregationMemoryEfficient = distributedAggregationMemoryEfficient;
    }

    public Long getMaxBytesBeforeExternalGroupBy() {
        return this.maxBytesBeforeExternalGroupBy;
    }

    public void setMaxBytesBeforeExternalGroupBy(Long maxBytesBeforeExternalGroupBy) {
        this.maxBytesBeforeExternalGroupBy = maxBytesBeforeExternalGroupBy;
    }

    public Long getMaxBytesBeforeExternalSort() {
        return this.maxBytesBeforeExternalSort;
    }

    public void setMaxBytesBeforeExternalSort(Long maxBytesBeforeExternalSort) {
        this.maxBytesBeforeExternalSort = maxBytesBeforeExternalSort;
    }

    public Long getMaxMemoryUsage() {
        return this.maxMemoryUsage;
    }

    public void setMaxMemoryUsage(Long maxMemoryUsage) {
        this.maxMemoryUsage = maxMemoryUsage;
    }

    public Long getPreferredBlockSizeBytes() {
        return this.preferredBlockSizeBytes;
    }

    public void setPreferredBlockSizeBytes(Long preferredBlockSizeBytes) {
        this.preferredBlockSizeBytes = preferredBlockSizeBytes;
    }

    public Long getMaxQuerySize() {
        return this.maxQuerySize;
    }

    public void setMaxQuerySize(Long maxQuerySize) {
        this.maxQuerySize = maxQuerySize;
    }

    public boolean isSessionCheck() {
        return this.sessionCheck;
    }

    public void setSessionCheck(boolean sessionCheck) {
        this.sessionCheck = sessionCheck;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    private static class PropertiesBuilder {
        private final Properties properties = new Properties();

        public void put(String key, int value) {
            this.properties.put(key, (Object)value);
        }

        public void put(String key, Integer value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }

        public void put(String key, Long value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }

        public void put(String key, boolean value) {
            this.properties.put(key, String.valueOf(value));
        }

        public void put(String key, String value) {
            if (value != null) {
                this.properties.put(key, value);
            }
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

