/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ru.yandex.clickhouse.settings.ClickHouseConnectionSettings;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.apache.StringUtils;

public class ClickHouseProperties {
    private boolean async;
    private int bufferSize;
    private int apacheBufferSize;
    private int socketTimeout;
    private int connectionTimeout;
    private int dataTransferTimeout;
    private int keepAliveTimeout;
    private int timeToLiveMillis;
    private int defaultMaxPerRoute;
    private int maxTotal;
    private Integer maxParallelReplicas;
    private String totalsMode;
    private String quotaKey;
    private Integer priority;
    private String database;
    private boolean compress;
    private boolean extremes;
    private Integer maxThreads;
    private Integer maxExecutionTime;
    private Integer maxBlockSize;
    private Integer maxRowsToGroupBy;
    private String profile;
    private String user;
    private String password;

    public ClickHouseProperties() {
        this(new Properties());
    }

    public ClickHouseProperties(Properties info) {
        this.async = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.ASYNC);
        this.bufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.BUFFER_SIZE);
        this.apacheBufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.APACHE_BUFFER_SIZE);
        this.socketTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.SOCKET_TIMEOUT);
        this.connectionTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.CONNECTION_TIMEOUT);
        this.dataTransferTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DATA_TRANSFER_TIMEOUT);
        this.keepAliveTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.KEEP_ALIVE_TIMEOUT);
        this.timeToLiveMillis = (Integer)this.getSetting(info, ClickHouseConnectionSettings.TIME_TO_LIVE_MILLIS);
        this.defaultMaxPerRoute = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DEFAULT_MAX_PER_ROUTE);
        this.maxTotal = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_TOTAL);
        this.maxParallelReplicas = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_PARALLEL_REPLICAS);
        this.totalsMode = (String)this.getSetting(info, ClickHouseQueryParam.TOTALS_MODE);
        this.quotaKey = (String)this.getSetting(info, ClickHouseQueryParam.QUOTA_KEY);
        this.priority = (Integer)this.getSetting(info, ClickHouseQueryParam.PRIORITY);
        this.database = (String)this.getSetting(info, ClickHouseQueryParam.DATABASE);
        this.compress = (Boolean)this.getSetting(info, ClickHouseQueryParam.COMPRESS);
        this.extremes = (Boolean)this.getSetting(info, ClickHouseQueryParam.EXTREMES);
        this.maxThreads = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_THREADS);
        this.maxExecutionTime = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_EXECUTION_TIME);
        this.maxBlockSize = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_BLOCK_SIZE);
        this.maxRowsToGroupBy = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY);
        this.profile = (String)this.getSetting(info, ClickHouseQueryParam.PROFILE);
        this.user = (String)this.getSetting(info, ClickHouseQueryParam.USER);
        this.password = (String)this.getSetting(info, ClickHouseQueryParam.PASSWORD);
    }

    public ClickHouseProperties(ClickHouseProperties properties) {
        this.setAsync(properties.async);
        this.setBufferSize(properties.bufferSize);
        this.setApacheBufferSize(properties.apacheBufferSize);
        this.setSocketTimeout(properties.socketTimeout);
        this.setConnectionTimeout(properties.connectionTimeout);
        this.setDataTransferTimeout(properties.dataTransferTimeout);
        this.setKeepAliveTimeout(properties.keepAliveTimeout);
        this.setTimeToLiveMillis(properties.timeToLiveMillis);
        this.setDefaultMaxPerRoute(properties.defaultMaxPerRoute);
        this.setMaxTotal(properties.maxTotal);
        this.setMaxParallelReplicas(properties.maxParallelReplicas);
        this.setTotalsMode(properties.totalsMode);
        this.setQuotaKey(properties.quotaKey);
        this.setPriority(properties.priority);
        this.setDatabase(properties.database);
        this.setCompress(properties.compress);
        this.setExtremes(properties.extremes);
        this.setMaxThreads(properties.maxThreads);
        this.setMaxExecutionTime(properties.maxExecutionTime);
        this.setMaxBlockSize(properties.maxBlockSize);
        this.setMaxRowsToGroupBy(properties.maxRowsToGroupBy);
        this.setProfile(properties.profile);
        this.setUser(properties.user);
        this.setPassword(properties.password);
    }

    public Map<ClickHouseQueryParam, String> buildParams(boolean ignoreDatabase) {
        HashMap<ClickHouseQueryParam, String> params = new HashMap<ClickHouseQueryParam, String>();
        if (this.maxParallelReplicas != null) {
            params.put(ClickHouseQueryParam.MAX_PARALLEL_REPLICAS, String.valueOf(this.maxParallelReplicas));
        }
        if (this.maxRowsToGroupBy != null) {
            params.put(ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY, String.valueOf(this.maxRowsToGroupBy));
        }
        if (this.totalsMode != null) {
            params.put(ClickHouseQueryParam.TOTALS_MODE, this.totalsMode);
        }
        if (this.quotaKey != null) {
            params.put(ClickHouseQueryParam.QUOTA_KEY, this.quotaKey);
        }
        if (this.priority != null) {
            params.put(ClickHouseQueryParam.PRIORITY, String.valueOf(this.priority));
        }
        if (!StringUtils.isBlank(this.database) && !ignoreDatabase) {
            params.put(ClickHouseQueryParam.DATABASE, this.getDatabase());
        }
        if (this.compress) {
            params.put(ClickHouseQueryParam.COMPRESS, "1");
        }
        if (this.extremes) {
            params.put(ClickHouseQueryParam.EXTREMES, "1");
        }
        if (StringUtils.isBlank(this.profile)) {
            if (this.getMaxThreads() != null) {
                params.put(ClickHouseQueryParam.MAX_THREADS, String.valueOf(this.maxThreads));
            }
            params.put(ClickHouseQueryParam.MAX_EXECUTION_TIME, String.valueOf((this.maxExecutionTime != null ? this.maxExecutionTime : this.socketTimeout + this.dataTransferTimeout) / 1000));
            if (this.getMaxBlockSize() != null) {
                params.put(ClickHouseQueryParam.MAX_BLOCK_SIZE, String.valueOf(this.getMaxBlockSize()));
            }
        } else {
            params.put(ClickHouseQueryParam.PROFILE, this.profile);
        }
        if (this.user != null) {
            params.put(ClickHouseQueryParam.USER, this.user);
        }
        if (this.password != null) {
            params.put(ClickHouseQueryParam.PASSWORD, this.password);
        }
        return params;
    }

    public ClickHouseProperties withCredentials(String user, String password) {
        ClickHouseProperties copy = new ClickHouseProperties(this);
        copy.setUser(user);
        copy.setPassword(password);
        return copy;
    }

    private <T> T getSetting(Properties info, ClickHouseQueryParam param) {
        return this.getSetting(info, param.getKey(), param.getDefaultValue(), param.getClazz());
    }

    private <T> T getSetting(Properties info, ClickHouseConnectionSettings settings) {
        return this.getSetting(info, settings.getKey(), settings.getDefaultValue(), settings.getClazz());
    }

    private <T> T getSetting(Properties info, String key, Object defaultValue, Class clazz) {
        Object val = info.get(key);
        if (val == null) {
            return (T)defaultValue;
        }
        if ((clazz == Integer.TYPE || clazz == Integer.class) && val instanceof String) {
            return clazz.cast(Integer.valueOf((String)val));
        }
        if ((clazz == Long.TYPE || clazz == Long.class) && val instanceof String) {
            return clazz.cast(Long.valueOf((String)val));
        }
        if ((clazz == Boolean.TYPE || clazz == Boolean.class) && val instanceof String) {
            return clazz.cast(Boolean.valueOf((String)val));
        }
        return clazz.cast(val);
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(Integer maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getApacheBufferSize() {
        return this.apacheBufferSize;
    }

    public void setApacheBufferSize(int apacheBufferSize) {
        this.apacheBufferSize = apacheBufferSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getDataTransferTimeout() {
        return this.dataTransferTimeout;
    }

    public void setDataTransferTimeout(int dataTransferTimeout) {
        this.dataTransferTimeout = dataTransferTimeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    public void setTimeToLiveMillis(int timeToLiveMillis) {
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public Integer getMaxParallelReplicas() {
        return this.maxParallelReplicas;
    }

    public void setMaxParallelReplicas(Integer maxParallelReplicas) {
        this.maxParallelReplicas = maxParallelReplicas;
    }

    public String getTotalsMode() {
        return this.totalsMode;
    }

    public void setTotalsMode(String totalsMode) {
        this.totalsMode = totalsMode;
    }

    public String getQuotaKey() {
        return this.quotaKey;
    }

    public void setQuotaKey(String quotaKey) {
        this.quotaKey = quotaKey;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean isExtremes() {
        return this.extremes;
    }

    public void setExtremes(boolean extremes) {
        this.extremes = extremes;
    }

    public Integer getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(Integer maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public Integer getMaxRowsToGroupBy() {
        return this.maxRowsToGroupBy;
    }

    public void setMaxRowsToGroupBy(Integer maxRowsToGroupBy) {
        this.maxRowsToGroupBy = maxRowsToGroupBy;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

