/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;

public class ClickhouseJdbcUrlParser {
    private static final Logger logger = LoggerFactory.getLogger(ClickhouseJdbcUrlParser.class);
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:clickhouse:";
    public static final Pattern DB_PATH_PATTERN = Pattern.compile("/([a-zA-Z0-9_*\\-]+)");
    protected static final String DEFAULT_DATABASE = "default";

    private ClickhouseJdbcUrlParser() {
    }

    public static ClickHouseProperties parse(String jdbcUrl, Properties defaults) throws URISyntaxException {
        if (!jdbcUrl.startsWith(JDBC_CLICKHOUSE_PREFIX)) {
            throw new URISyntaxException(jdbcUrl, "'jdbc:clickhouse:' prefix is mandatory");
        }
        return ClickhouseJdbcUrlParser.parseClickhouseUrl(jdbcUrl.substring(JDBC_PREFIX.length()), defaults);
    }

    private static ClickHouseProperties parseClickhouseUrl(String uriString, Properties defaults) throws URISyntaxException {
        String database;
        URI uri = new URI(uriString);
        Properties urlProperties = ClickhouseJdbcUrlParser.parseUriQueryPart(uri, defaults);
        ClickHouseProperties props = new ClickHouseProperties(urlProperties);
        props.setHost(uri.getHost());
        int port = uri.getPort();
        if (port == -1) {
            throw new IllegalArgumentException("port is missed or wrong");
        }
        props.setPort(port);
        String path = uri.getPath();
        if (path == null || path.isEmpty() || path.equals("/")) {
            String defaultsDb = defaults.getProperty(ClickHouseQueryParam.DATABASE.getKey());
            database = defaultsDb == null ? DEFAULT_DATABASE : defaultsDb;
        } else {
            Matcher m = DB_PATH_PATTERN.matcher(path);
            if (m.matches()) {
                database = m.group(1);
            } else {
                throw new URISyntaxException("wrong database name path: '" + path + "'", uriString);
            }
        }
        props.setDatabase(database);
        return props;
    }

    private static Properties parseUriQueryPart(URI uri, Properties defaults) {
        String[] queryKeyVaues;
        String query = uri.getQuery();
        if (query == null) {
            return defaults;
        }
        Properties urlProps = new Properties(defaults);
        for (String keyValue : queryKeyVaues = query.split("&")) {
            String[] keyValueTokens = keyValue.split("=");
            if (keyValueTokens.length == 2) {
                urlProps.put(keyValueTokens[0], keyValueTokens[1]);
                continue;
            }
            logger.warn("don't know how to handle parameter pair: {}", (Object)keyValue);
        }
        return urlProps;
    }
}

