/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.except;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.except.ClickHouseErrorCode;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.util.apache.StringUtils;

public final class ClickHouseExceptionSpecifier {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseExceptionSpecifier.class);

    private ClickHouseExceptionSpecifier() {
    }

    public static ClickHouseException specify(Throwable cause, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(null, cause, host, port);
    }

    public static ClickHouseException specify(String clickHouseMessage, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(clickHouseMessage, null, host, port);
    }

    public static ClickHouseException specify(String clickHouseMessage, Throwable cause, String host, int port) {
        if (StringUtils.isEmpty(clickHouseMessage) && cause != null) {
            if (cause instanceof SocketTimeoutException) {
                return new ClickHouseException(ClickHouseErrorCode.TIMEOUT_EXCEEDED.code, cause, host, port);
            }
            if (cause instanceof ConnectTimeoutException || cause instanceof ConnectException) {
                return new ClickHouseException(ClickHouseErrorCode.NETWORK_ERROR.code, cause, host, port);
            }
            return new ClickHouseUnknownException(cause, host, port);
        }
        try {
            int code = clickHouseMessage.startsWith("Poco::Exception. Code: 1000, ") ? 1000 : Integer.parseInt(clickHouseMessage.substring(clickHouseMessage.indexOf(32) + 1, clickHouseMessage.indexOf(44)));
            Throwable messageHolder = cause != null ? cause : new Throwable(clickHouseMessage);
            return new ClickHouseException(code, messageHolder, host, port);
        }
        catch (Exception e) {
            log.error("Unsupported ClickHouse error format, please fix ClickHouseExceptionSpecifier, message: " + clickHouseMessage + ", error: " + e.getMessage());
            return new ClickHouseUnknownException(clickHouseMessage, cause, host, port);
        }
    }

    private static interface ClickHouseExceptionFactory {
        public ClickHouseException create(Integer var1, Throwable var2, String var3, int var4);
    }
}

