/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TimeZone;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryStream;
import ru.yandex.clickhouse.util.ClickHouseStreamCallback;
import ru.yandex.repackaged.com.google.common.base.Preconditions;
import ru.yandex.repackaged.org.apache.http.entity.AbstractHttpEntity;

public class ClickHouseStreamHttpEntity
extends AbstractHttpEntity {
    private final ClickHouseStreamCallback callback;
    private final TimeZone timeZone;
    private final ClickHouseProperties properties;

    public ClickHouseStreamHttpEntity(ClickHouseStreamCallback callback, TimeZone timeZone, ClickHouseProperties properties) {
        Preconditions.checkNotNull(callback);
        this.timeZone = timeZone;
        this.callback = callback;
        this.properties = properties;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return null;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        ClickHouseRowBinaryStream stream = new ClickHouseRowBinaryStream(out, this.timeZone, this.properties);
        this.callback.writeTo(stream);
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

