/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.repackaged.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import ru.yandex.repackaged.com.fasterxml.jackson.core.JsonGenerator;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.JavaType;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.JsonMappingException;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.JsonNode;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.SerializerProvider;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.node.ObjectNode;
import ru.yandex.repackaged.com.fasterxml.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, g);
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffixForScalar(value, g);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

