/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.repackaged.com.google.common.base;

import java.lang.ref.WeakReference;
import ru.yandex.repackaged.com.google.common.annotations.GwtCompatible;
import ru.yandex.repackaged.com.google.common.base.CharMatcher;
import ru.yandex.repackaged.com.google.common.base.Enums;
import ru.yandex.repackaged.com.google.common.base.Optional;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }
}

