/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.repackaged.com.google.common.util.concurrent;

import java.util.List;
import javax.annotation.Nullable;
import ru.yandex.repackaged.com.google.common.annotations.GwtCompatible;
import ru.yandex.repackaged.com.google.common.base.Optional;
import ru.yandex.repackaged.com.google.common.base.Preconditions;
import ru.yandex.repackaged.com.google.common.collect.ImmutableCollection;
import ru.yandex.repackaged.com.google.common.collect.ImmutableList;
import ru.yandex.repackaged.com.google.common.collect.Lists;
import ru.yandex.repackaged.com.google.common.util.concurrent.AggregateFuture;
import ru.yandex.repackaged.com.google.common.util.concurrent.ListenableFuture;

@GwtCompatible
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed, true);
            this.values = (List)((Object)(futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size())));
            for (int i = 0; i < futures.size(); ++i) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean allMustSucceed, int index, @Nullable V returnValue) {
            List localValues = this.values;
            if (localValues != null) {
                localValues.set(index, Optional.fromNullable(returnValue));
            } else {
                Preconditions.checkState(allMustSucceed || CollectionFuture.this.isCancelled(), "Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List localValues = this.values;
            if (localValues != null) {
                CollectionFuture.this.set(this.combine(localValues));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

