/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.repackaged.org.apache.http.impl.cookie;

import ru.yandex.repackaged.org.apache.http.annotation.Immutable;
import ru.yandex.repackaged.org.apache.http.cookie.CommonCookieAttributeHandler;
import ru.yandex.repackaged.org.apache.http.cookie.Cookie;
import ru.yandex.repackaged.org.apache.http.cookie.CookieOrigin;
import ru.yandex.repackaged.org.apache.http.cookie.CookieRestrictionViolationException;
import ru.yandex.repackaged.org.apache.http.cookie.MalformedCookieException;
import ru.yandex.repackaged.org.apache.http.cookie.SetCookie;
import ru.yandex.repackaged.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import ru.yandex.repackaged.org.apache.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

