/* ClickHouseSqlParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. ClickHouseSqlParser.java */
package ru.yandex.clickhouse.jdbc.parser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.StringReader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class ClickHouseSqlParser implements ClickHouseSqlParserConstants {
    private static final boolean DEBUG = false;

    private static final Logger log = LoggerFactory.getLogger(ClickHouseSqlParser.class);

    private final List<ClickHouseSqlStatement> statements = new ArrayList<>();

    private ClickHouseProperties properties;
    private ParseHandler handler;

    private boolean tokenIn(int tokenIndex, int... tokens) {
        boolean matched = false;

        int t = getToken(tokenIndex).kind;
        if (tokens != null) {
            for (int i : tokens) {
                if (t == i) {
                    matched = true;
                    break;
                }
            }
        }

        return matched;
    }

    // FIXME ugly workaround but performs better than adding another lexical state for <BETWEEN>...<AND>
    private boolean noAndWithinBetween() {
        return !(getToken(1).kind == AND && token_source.parentToken == BETWEEN);
    }

    public static ClickHouseSqlStatement[] parse(String sql, ClickHouseProperties properties) {
        return parse(sql, properties, null);
    }

    public static ClickHouseSqlStatement[] parse(String sql, ClickHouseProperties properties, ParseHandler handler) {
        if (properties == null) {
            properties = new ClickHouseProperties();
        }

        ClickHouseSqlStatement[] stmts = new ClickHouseSqlStatement[] {
                new ClickHouseSqlStatement(sql, StatementType.UNKNOWN) };

        if (sql == null || sql.isEmpty()) {
            return stmts;
        }

        ClickHouseSqlParser p = new ClickHouseSqlParser(sql, properties, handler);
        try {
            stmts = p.sql();
        } catch (Exception e) {
            if (DEBUG) {
                throw new IllegalArgumentException(e);
            } else {
                log.warn("{}. If you believe the SQL is valid, please feel free to open an issue on Github with this warning and the following SQL attached.\n{}", e.getMessage(), sql);
            }
        }

        return stmts;
    }

    public ClickHouseSqlParser(String sql, ClickHouseProperties properties, ParseHandler handler) {
        this(new StringReader(sql));

        this.properties = properties;
        this.handler = handler;
    }

    public void addStatement() {
        if (token_source.isValid()) {
            ClickHouseSqlStatement sqlStmt = token_source.build(handler);
            // FIXME remove the restriction once we can hanlde insertion with format well
            if (statements.size() == 0 || sqlStmt.isRecognized()) {
                statements.add(sqlStmt);
            }
        } else {
            token_source.reset();
        }
    }

// top-level statements
  final public ClickHouseSqlStatement[] sql() throws ParseException {
    stmts();
addStatement();
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case SEMICOLON:{
        break;
        }
      default:
        break label_1;
      }
      label_2:
      while (true) {
        jj_consume_token(SEMICOLON);
        if (jj_2_1(2)) {
        } else {
          break label_2;
        }
      }
      if (jj_2_2(1)) {
        stmts();
      } else {
        ;
      }
addStatement();
    }
    jj_consume_token(0);
{if ("" != null) return statements.toArray(new ClickHouseSqlStatement[statements.size()]);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void stmts() throws ParseException {Token t;
    if (jj_2_3(2)) {
      stmt();
    } else if (jj_2_4(2)) {
      anyExprList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void stmt() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:{
      alterStmt();
if (token_source.stmtType == StatementType.UNKNOWN) token_source.stmtType = StatementType.ALTER;
      break;
      }
    case ATTACH:{
      attachStmt();
token_source.stmtType = StatementType.ATTACH;
      break;
      }
    case CHECK:{
      checkStmt();
token_source.stmtType = StatementType.CHECK;
      break;
      }
    case CREATE:{
      createStmt();
token_source.stmtType = StatementType.CREATE;
      break;
      }
    case DELETE:{
      deleteStmt();
token_source.stmtType = StatementType.DELETE;
      break;
      }
    case DESC:
    case DESCRIBE:{
      describeStmt();
token_source.stmtType = StatementType.DESCRIBE;
      break;
      }
    case DETACH:{
      detachStmt();
token_source.stmtType = StatementType.DETACH;
      break;
      }
    case DROP:{
      dropStmt();
token_source.stmtType = StatementType.DROP;
      break;
      }
    case EXISTS:{
      existsStmt();
token_source.stmtType = StatementType.EXISTS;
      break;
      }
    case EXPLAIN:{
      explainStmt();
token_source.stmtType = StatementType.EXPLAIN;
      break;
      }
    case INSERT:{
      insertStmt();
token_source.stmtType = StatementType.INSERT;
      break;
      }
    case GRANT:{
      grantStmt();
token_source.stmtType = StatementType.GRANT;
      break;
      }
    case KILL:{
      killStmt();
token_source.stmtType = StatementType.KILL;
      break;
      }
    case OPTIMIZE:{
      optimizeStmt();
token_source.stmtType = StatementType.OPTIMIZE;
      break;
      }
    case RENAME:{
      renameStmt();
token_source.stmtType = StatementType.RENAME;
      break;
      }
    case REVOKE:{
      revokeStmt();
token_source.stmtType = StatementType.REVOKE;
      break;
      }
    case SELECT:
    case WITH:{
      selectStmt();
token_source.stmtType = StatementType.SELECT;
      break;
      }
    case SET:{
      setStmt();
token_source.stmtType = StatementType.SET;
      break;
      }
    case SHOW:{
      showStmt();
token_source.stmtType = StatementType.SHOW;
      break;
      }
    case SYSTEM:{
      systemStmt();
token_source.stmtType = StatementType.SYSTEM;
      break;
      }
    case TRUNCATE:{
      truncateStmt();
token_source.stmtType = StatementType.TRUNCATE;
      break;
      }
    case UPDATE:{
      updateStmt();
token_source.stmtType = StatementType.UPDATE;
      break;
      }
    case USE:{
      useStmt();
token_source.stmtType = StatementType.USE;
      break;
      }
    case WATCH:{
      watchStmt();
token_source.stmtType = StatementType.WATCH;
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/alter/
  final public void alterStmt() throws ParseException {
    jj_consume_token(ALTER);
    if (jj_2_6(2)) {
      jj_consume_token(TABLE);
      tableIdentifier(true);
      if (jj_2_5(2)) {
        clusterClause();
      } else {
        ;
      }
      if (!tokenIn(1, UPDATE, DELETE)) {
        anyIdentifier();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case UPDATE:{
          jj_consume_token(UPDATE);
token_source.stmtType = StatementType.ALTER_UPDATE;
          break;
          }
        case DELETE:{
          jj_consume_token(DELETE);
token_source.stmtType = StatementType.ALTER_DELETE;
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else {
      ;
    }
    if (jj_2_7(1)) {
      anyExprList();
    } else {
      ;
    }
}

  final public void clusterClause() throws ParseException {Token t;
    jj_consume_token(ON);
    jj_consume_token(CLUSTER);
    if (jj_2_8(2)) {
      t = anyIdentifier();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case STRING_LITERAL:{
        t = jj_consume_token(STRING_LITERAL);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
token_source.cluster = ClickHouseSqlUtils.unescape(t.image);
}

// https://clickhouse.tech/docs/en/sql-reference/statements/attach/
  final public void attachStmt() throws ParseException {Token t;
    jj_consume_token(ATTACH);
    if (jj_2_10(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
token_source.setPosition(t.image);
        break;
        }
      case DICTIONARY:{
        jj_consume_token(DICTIONARY);
        break;
        }
      case OR:{
        jj_consume_token(OR);
        t = jj_consume_token(REPLACE);
token_source.setPosition(t.image);
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TEMPORARY:
        case TABLE:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TEMPORARY:{
            jj_consume_token(TEMPORARY);
            break;
            }
          default:
            ;
          }
          jj_consume_token(TABLE);
          break;
          }
        case LIVE:
        case MATERIALIZED:
        case VIEW:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LIVE:
          case MATERIALIZED:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case LIVE:{
              jj_consume_token(LIVE);
              break;
              }
            case MATERIALIZED:{
              jj_consume_token(MATERIALIZED);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            ;
          }
          jj_consume_token(VIEW);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_9(2)) {
        jj_consume_token(IF);
        jj_consume_token(NOT);
        t = jj_consume_token(EXISTS);
token_source.setPosition(t.image);
      } else {
        ;
      }
    } else {
      ;
    }
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/check-table/
  final public void checkStmt() throws ParseException {
    jj_consume_token(CHECK);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/create/
  final public void createStmt() throws ParseException {Token t;
    jj_consume_token(CREATE);
    if (jj_2_12(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
token_source.setPosition(t.image);
        break;
        }
      case LIVE:
      case MATERIALIZED:
      case OR:
      case TEMPORARY:
      case TABLE:
      case VIEW:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case OR:{
          jj_consume_token(OR);
          t = jj_consume_token(REPLACE);
token_source.setPosition(t.image);
          break;
          }
        default:
          ;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TEMPORARY:
        case TABLE:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case TEMPORARY:{
            jj_consume_token(TEMPORARY);
            break;
            }
          default:
            ;
          }
          jj_consume_token(TABLE);
          break;
          }
        case LIVE:
        case MATERIALIZED:
        case VIEW:{
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LIVE:
          case MATERIALIZED:{
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case LIVE:{
              jj_consume_token(LIVE);
              break;
              }
            case MATERIALIZED:{
              jj_consume_token(MATERIALIZED);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            ;
          }
          jj_consume_token(VIEW);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      case DICTIONARY:{
        jj_consume_token(DICTIONARY);
        break;
        }
      case USER:{
        jj_consume_token(USER);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        break;
        }
      case POLICY:
      case ROW:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ROW:{
          jj_consume_token(ROW);
          break;
          }
        default:
          ;
        }
        jj_consume_token(POLICY);
        break;
        }
      case QUOTA:{
        jj_consume_token(QUOTA);
        break;
        }
      case PROFILE:
      case SETTINGS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SETTINGS:{
          jj_consume_token(SETTINGS);
          break;
          }
        default:
          ;
        }
        jj_consume_token(PROFILE);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_11(2)) {
        jj_consume_token(IF);
        jj_consume_token(NOT);
        t = jj_consume_token(EXISTS);
token_source.setPosition(t.image);
      } else {
        ;
      }
    } else {
      ;
    }
    anyExprList();
}

// upcoming lightweight mutation - see https://github.com/ClickHouse/ClickHouse/issues/19627
  final public void deleteStmt() throws ParseException {
    jj_consume_token(DELETE);
    jj_consume_token(FROM);
    tableIdentifier(true);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WHERE:{
      jj_consume_token(WHERE);
      anyExprList();
      break;
      }
    default:
      ;
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/describe-table/
  final public void describeStmt() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DESCRIBE:{
      jj_consume_token(DESCRIBE);
      break;
      }
    case DESC:{
      jj_consume_token(DESC);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
token_source.table = "columns";
    if (getToken(1).kind == TABLE) {
      jj_consume_token(TABLE);
    } else {
      ;
    }
    tableIdentifier(true);
    if (jj_2_13(1)) {
      anyExprList();
    } else {
      ;
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/detach/
  final public void detachStmt() throws ParseException {Token t;
    jj_consume_token(DETACH);
    if (jj_2_15(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
token_source.setPosition(t.image);
        break;
        }
      case TEMPORARY:
      case TABLE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TEMPORARY:{
          jj_consume_token(TEMPORARY);
          break;
          }
        default:
          ;
        }
        jj_consume_token(TABLE);
        break;
        }
      case VIEW:{
        jj_consume_token(VIEW);
        break;
        }
      case DICTIONARY:{
        jj_consume_token(DICTIONARY);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_14(2)) {
        jj_consume_token(IF);
        t = jj_consume_token(EXISTS);
token_source.setPosition(t.image);
      } else {
        ;
      }
    } else {
      ;
    }
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/drop/
  final public void dropStmt() throws ParseException {Token t;
    jj_consume_token(DROP);
    if (jj_2_17(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DATABASE:{
        t = jj_consume_token(DATABASE);
token_source.setPosition(t.image);
        break;
        }
      case TEMPORARY:
      case TABLE:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case TEMPORARY:{
          jj_consume_token(TEMPORARY);
          break;
          }
        default:
          ;
        }
        jj_consume_token(TABLE);
        break;
        }
      case VIEW:{
        jj_consume_token(VIEW);
        break;
        }
      case DICTIONARY:{
        jj_consume_token(DICTIONARY);
        break;
        }
      case USER:{
        jj_consume_token(USER);
        break;
        }
      case ROLE:{
        jj_consume_token(ROLE);
        break;
        }
      case POLICY:
      case ROW:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ROW:{
          jj_consume_token(ROW);
          break;
          }
        default:
          ;
        }
        jj_consume_token(POLICY);
        break;
        }
      case QUOTA:{
        jj_consume_token(QUOTA);
        break;
        }
      case PROFILE:
      case SETTINGS:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case SETTINGS:{
          jj_consume_token(SETTINGS);
          break;
          }
        default:
          ;
        }
        jj_consume_token(PROFILE);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_16(2)) {
        jj_consume_token(IF);
        t = jj_consume_token(EXISTS);
token_source.setPosition(t.image);
      } else {
        ;
      }
    } else {
      ;
    }
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/exists/
  final public void existsStmt() throws ParseException {
    jj_consume_token(EXISTS);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/explain/
  final public void explainStmt() throws ParseException {
    jj_consume_token(EXPLAIN);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/grant/
  final public void grantStmt() throws ParseException {
    jj_consume_token(GRANT);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/insert-into/
  final public void insertStmt() throws ParseException {
    jj_consume_token(INSERT);
    jj_consume_token(INTO);
    if (getToken(1).kind == FUNCTION) {
      jj_consume_token(FUNCTION);
      functionExpr();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case ATTACH:
      case CHECK:
      case CREATE:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DETACH:
      case DROP:
      case EXISTS:
      case EXPLAIN:
      case GRANT:
      case INSERT:
      case KILL:
      case OPTIMIZE:
      case RENAME:
      case REVOKE:
      case SELECT:
      case SET:
      case SHOW:
      case SYSTEM:
      case TRUNCATE:
      case UPDATE:
      case USE:
      case WATCH:
      case ALL:
      case AND:
      case APPLY:
      case ARRAY:
      case AS:
      case ASOF:
      case BETWEEN:
      case CASE:
      case CLUSTER:
      case DATE:
      case DATABASE:
      case DATABASES:
      case DICTIONARY:
      case DICTIONARIES:
      case DISTINCT:
      case ELSE:
      case END:
      case EXCEPT:
      case FINAL:
      case FORMAT:
      case FROM:
      case FULL:
      case FUNCTION:
      case GLOBAL:
      case GROUP:
      case HAVING:
      case IF:
      case ILIKE:
      case IN:
      case INNER:
      case INTERVAL:
      case INTO:
      case IS:
      case JOIN:
      case LEFT:
      case LIKE:
      case LIMIT:
      case LIVE:
      case MATERIALIZED:
      case NOT:
      case OFFSET:
      case ON:
      case OR:
      case ORDER:
      case OUTFILE:
      case POLICY:
      case PREWHERE:
      case PROFILE:
      case QUOTA:
      case REPLACE:
      case ROLE:
      case ROW:
      case RIGHT:
      case SAMPLE:
      case SETTINGS:
      case TEMPORARY:
      case TABLE:
      case TABLES:
      case THEN:
      case TIES:
      case TIMESTAMP:
      case TOP:
      case TOTALS:
      case UNION:
      case USER:
      case USING:
      case VALUES:
      case VIEW:
      case WHEN:
      case WHERE:
      case WITH:
      case SECOND:
      case MINUTE:
      case HOUR:
      case DAY:
      case WEEK:
      case MONTH:
      case QUARTER:
      case YEAR:
      case INF:
      case NAN:
      case NULL:
      case AT:
      case IDENTIFIER:
      case BACK_QUOTED_NAME:
      case DOUBLE_QUOTED_NAME:{
        if (jj_2_18(2)) {
          jj_consume_token(TABLE);
        } else {
          ;
        }
        tableIdentifier(true);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_19(2)) {
      jj_consume_token(LPAREN);
      columnExprList();
      jj_consume_token(RPAREN);
    } else {
      ;
    }
    dataClause();
}

  final public void dataClause() throws ParseException {Token t;
    try {
      if (jj_2_22(2)) {
        jj_consume_token(FORMAT);
        anyIdentifier();
        if (jj_2_20(2)) {
          anyExprList();
        } else {
          ;
        }
      } else if (jj_2_23(2)) {
        t = jj_consume_token(VALUES);
token_source.setPosition(t.image);
        jj_consume_token(LPAREN);
        columnExprList();
        jj_consume_token(RPAREN);
        label_3:
        while (true) {
          if (jj_2_21(2)) {
          } else {
            break label_3;
          }
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            break;
            }
          default:
            ;
          }
          jj_consume_token(LPAREN);
          columnExprList();
          jj_consume_token(RPAREN);
        }
      } else if (jj_2_24(1)) {
        anyExprList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (ParseException e) {
// FIXME introduce a lexical state in next release with consideration of delimiter from the context
        Token nextToken;
        do {
            nextToken = getNextToken();
        } while(nextToken.kind != SEMICOLON && nextToken.kind != EOF);
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/kill/
  final public void killStmt() throws ParseException {
    jj_consume_token(KILL);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/optimize/
  final public void optimizeStmt() throws ParseException {
    jj_consume_token(OPTIMIZE);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/rename/
  final public void renameStmt() throws ParseException {
    jj_consume_token(RENAME);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/revoke/
  final public void revokeStmt() throws ParseException {
    jj_consume_token(REVOKE);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/select/
  final public void selectStmt() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case WITH:{
      withClause();
      break;
      }
    default:
      ;
    }
    jj_consume_token(SELECT);
    if (jj_2_25(2)) {
      jj_consume_token(DISTINCT);
    } else {
      ;
    }
    if (jj_2_26(2)) {
      topClause();
    } else {
      ;
    }
    columnExprList();
    if (jj_2_27(2)) {
      jj_consume_token(FROM);
      tableClause(true);
      label_4:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          break label_4;
        }
        jj_consume_token(COMMA);
        tableClause(false);
      }
    } else {
      ;
    }
    if (jj_2_28(2)) {
      anyExprList();
    } else {
      ;
    }
}

  final public void withClause() throws ParseException {
    jj_consume_token(WITH);
token_source.enterToken(WITH);
    withExpr();
    label_5:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        break label_5;
      }
      jj_consume_token(COMMA);
      withExpr();
    }
token_source.leaveToken(WITH);
}

  final public void topClause() throws ParseException {
    jj_consume_token(TOP);
    jj_consume_token(DECIMAL_LITERAL);
    if (jj_2_29(2)) {
      jj_consume_token(WITH);
      jj_consume_token(TIES);
    } else {
      ;
    }
}

  final public void tableClause(boolean record) throws ParseException {Token t;
    if (jj_2_30(2)) {
      tableIdentifier(record);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case LPAREN:{
        jj_consume_token(LPAREN);
        anyExprList();
        jj_consume_token(RPAREN);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_31(2)) {
      t = aliasExpr();
if (record && t != null && token_source.table == null) token_source.table = ClickHouseSqlUtils.unescape(t.image);
    } else {
      ;
    }
    if (jj_2_32(2)) {
      jj_consume_token(FINAL);
    } else {
      ;
    }
    if (jj_2_36(2)) {
      jj_consume_token(SAMPLE);
      numberLiteral();
      if (jj_2_33(2)) {
        jj_consume_token(SLASH);
        numberLiteral();
      } else {
        ;
      }
      if (jj_2_35(2)) {
        jj_consume_token(OFFSET);
        numberLiteral();
        if (jj_2_34(2)) {
          jj_consume_token(SLASH);
          numberLiteral();
        } else {
          ;
        }
      } else {
        ;
      }
    } else {
      ;
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/set/
// https://clickhouse.tech/docs/en/sql-reference/statements/set-role/
  final public void setStmt() throws ParseException {
    jj_consume_token(SET);
    if (jj_2_37(2)) {
      settingExprList();
    } else if (jj_2_38(1)) {
      anyExprList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/show/
  final public void showStmt() throws ParseException {
    jj_consume_token(SHOW);
    if (jj_2_46(2)) {
      jj_consume_token(DATABASES);
token_source.table = "databases";
    } else if (jj_2_47(2)) {
      jj_consume_token(DICTIONARIES);
token_source.table = "dictionaries";
      if (jj_2_39(2)) {
        jj_consume_token(FROM);
        databaseIdentifier(true);
      } else {
        ;
      }
    } else if (jj_2_48(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case TEMPORARY:{
        jj_consume_token(TEMPORARY);
        break;
        }
      default:
        ;
      }
      jj_consume_token(TABLES);
token_source.table = "tables";
      if (jj_2_40(2)) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case FROM:{
          jj_consume_token(FROM);
          break;
          }
        case IN:{
          jj_consume_token(IN);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        databaseIdentifier(true);
      } else {
        ;
      }
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case ATTACH:
      case CHECK:
      case CREATE:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DETACH:
      case DROP:
      case EXISTS:
      case EXPLAIN:
      case GRANT:
      case INSERT:
      case KILL:
      case OPTIMIZE:
      case RENAME:
      case REVOKE:
      case SELECT:
      case SET:
      case SHOW:
      case SYSTEM:
      case TRUNCATE:
      case UPDATE:
      case USE:
      case WATCH:
      case ALL:
      case AND:
      case APPLY:
      case ARRAY:
      case AS:
      case ASOF:
      case BETWEEN:
      case CASE:
      case CLUSTER:
      case DATE:
      case DATABASE:
      case DATABASES:
      case DICTIONARY:
      case DICTIONARIES:
      case DISTINCT:
      case ELSE:
      case END:
      case EXCEPT:
      case FINAL:
      case FORMAT:
      case FROM:
      case FULL:
      case FUNCTION:
      case GLOBAL:
      case GROUP:
      case HAVING:
      case IF:
      case ILIKE:
      case IN:
      case INNER:
      case INTERVAL:
      case INTO:
      case IS:
      case JOIN:
      case LEFT:
      case LIKE:
      case LIMIT:
      case LIVE:
      case MATERIALIZED:
      case NOT:
      case OFFSET:
      case ON:
      case OR:
      case ORDER:
      case OUTFILE:
      case POLICY:
      case PREWHERE:
      case PROFILE:
      case QUOTA:
      case REPLACE:
      case ROLE:
      case ROW:
      case RIGHT:
      case SAMPLE:
      case SETTINGS:
      case TEMPORARY:
      case TABLE:
      case TABLES:
      case THEN:
      case TIES:
      case TIMESTAMP:
      case TOP:
      case TOTALS:
      case UNION:
      case USER:
      case USING:
      case VALUES:
      case VIEW:
      case WHEN:
      case WHERE:
      case WITH:
      case SECOND:
      case MINUTE:
      case HOUR:
      case DAY:
      case WEEK:
      case MONTH:
      case QUARTER:
      case YEAR:
      case INF:
      case NAN:
      case NULL:
      case AT:
      case IDENTIFIER:
      case BACK_QUOTED_NAME:
      case DOUBLE_QUOTED_NAME:{
        if (jj_2_43(2)) {
          jj_consume_token(CREATE);
          jj_consume_token(DATABASE);
          databaseIdentifier(true);
        } else if (jj_2_44(2)) {
          jj_consume_token(DICTIONARY);
          tableIdentifier(true);
        } else if (jj_2_45(2)) {
          if (jj_2_41(2)) {
            jj_consume_token(TEMPORARY);
          } else {
            ;
          }
          if (jj_2_42(2)) {
            jj_consume_token(TABLE);
          } else {
            ;
          }
          tableIdentifier(true);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
token_source.database = "system";
    if (jj_2_49(2)) {
      anyExprList();
    } else {
      ;
    }
}

// https://clickhouse.tech/docs/en/sql-reference/statements/system/
  final public void systemStmt() throws ParseException {
    jj_consume_token(SYSTEM);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/truncate/
  final public void truncateStmt() throws ParseException {
    jj_consume_token(TRUNCATE);
    if (jj_2_50(2)) {
      jj_consume_token(TEMPORARY);
    } else {
      ;
    }
    if (jj_2_51(2)) {
      jj_consume_token(TABLE);
    } else {
      ;
    }
    if (jj_2_52(2)) {
      jj_consume_token(IF);
      jj_consume_token(EXISTS);
    } else {
      ;
    }
    tableIdentifier(true);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ON:{
      clusterClause();
      break;
      }
    default:
      ;
    }
}

// upcoming lightweight mutation - see https://github.com/ClickHouse/ClickHouse/issues/19627
  final public void updateStmt() throws ParseException {
    jj_consume_token(UPDATE);
    anyExprList();
}

// https://clickhouse.tech/docs/en/sql-reference/statements/use/
  final public void useStmt() throws ParseException {
    jj_consume_token(USE);
    databaseIdentifier(true);
}

// Experimental LIVE VIEW feature
  final public void watchStmt() throws ParseException {
    jj_consume_token(WATCH);
    anyExprList();
}

// columns
  final public void columnExprList() throws ParseException {
    columnsExpr();
    label_6:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        break label_6;
      }
      jj_consume_token(COMMA);
      columnsExpr();
    }
}

  final public void withExpr() throws ParseException {
    nestedExpr();
    if (jj_2_64(1)) {
      if (jj_2_56(1)) {
        label_7:
        while (true) {
          if (getToken(1).kind == FLOATING_LITERAL) {
            jj_consume_token(FLOATING_LITERAL);
          } else {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DOT:{
              jj_consume_token(DOT);
              jj_consume_token(DECIMAL_LITERAL);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          if (jj_2_53(1)) {
          } else {
            break label_7;
          }
        }
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case LBRACKET:{
          label_8:
          while (true) {
            jj_consume_token(LBRACKET);
            anyExprList();
            jj_consume_token(RBRACKET);
            if (jj_2_54(2)) {
            } else {
              break label_8;
            }
          }
          break;
          }
        default:
          if (jj_2_57(2)) {
            jj_consume_token(IS);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            jj_consume_token(NULL);
          } else if (jj_2_58(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            betweenExpr();
          } else if (jj_2_59(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case ILIKE:{
              jj_consume_token(ILIKE);
              break;
              }
            case LIKE:{
              jj_consume_token(LIKE);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            nestedExpr();
          } else if (jj_2_60(2) && (noAndWithinBetween())) {
            label_9:
            while (true) {
              calcExpr();
              if (jj_2_55(2) && (noAndWithinBetween())) {
              } else {
                break label_9;
              }
            }
          } else if (jj_2_61(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            jj_consume_token(IN);
            nestedExpr();
          } else if (jj_2_62(2)) {
            jj_consume_token(QUERY);
            nestedExpr();
            jj_consume_token(COLON);
            nestedExpr();
          } else if (jj_2_63(2)) {
            jj_consume_token(AS);
            columnExpr();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } else {
      ;
    }
}

  final public void columnsExpr() throws ParseException {
    if (jj_2_78(2147483647)) {
      allColumnsExpr();
      label_10:
      while (true) {
        if (jj_2_65(2)) {
        } else {
          break label_10;
        }
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case APPLY:{
          jj_consume_token(APPLY);
          break;
          }
        case EXCEPT:{
          jj_consume_token(EXCEPT);
          break;
          }
        case REPLACE:{
          jj_consume_token(REPLACE);
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(LPAREN);
        anyExprList();
        jj_consume_token(RPAREN);
      }
    } else if (jj_2_79(1)) {
      nestedExpr();
      if (jj_2_77(1)) {
        if (jj_2_69(1)) {
          label_11:
          while (true) {
            if (getToken(1).kind == FLOATING_LITERAL) {
              jj_consume_token(FLOATING_LITERAL);
            } else {
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case DOT:{
                jj_consume_token(DOT);
                jj_consume_token(DECIMAL_LITERAL);
                break;
                }
              default:
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
            if (jj_2_66(1)) {
            } else {
              break label_11;
            }
          }
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case LBRACKET:{
            label_12:
            while (true) {
              jj_consume_token(LBRACKET);
              anyExprList();
              jj_consume_token(RBRACKET);
              if (jj_2_67(2)) {
              } else {
                break label_12;
              }
            }
            break;
            }
          default:
            if (jj_2_70(2)) {
              jj_consume_token(IS);
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case NOT:{
                jj_consume_token(NOT);
                break;
                }
              default:
                ;
              }
              jj_consume_token(NULL);
            } else if (jj_2_71(2)) {
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case NOT:{
                jj_consume_token(NOT);
                break;
                }
              default:
                ;
              }
              betweenExpr();
            } else if (jj_2_72(2)) {
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case NOT:{
                jj_consume_token(NOT);
                break;
                }
              default:
                ;
              }
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case ILIKE:{
                jj_consume_token(ILIKE);
                break;
                }
              case LIKE:{
                jj_consume_token(LIKE);
                break;
                }
              default:
                jj_consume_token(-1);
                throw new ParseException();
              }
              nestedExpr();
            } else if (jj_2_73(2) && (noAndWithinBetween())) {
              label_13:
              while (true) {
                calcExpr();
                if (jj_2_68(2) && (noAndWithinBetween())) {
                } else {
                  break label_13;
                }
              }
            } else if (jj_2_74(2)) {
              switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
              case NOT:{
                jj_consume_token(NOT);
                break;
                }
              default:
                ;
              }
              jj_consume_token(IN);
              nestedExpr();
            } else if (jj_2_75(2)) {
              jj_consume_token(QUERY);
              nestedExpr();
              jj_consume_token(COLON);
              nestedExpr();
            } else if (jj_2_76(2)) {
              aliasExpr();
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void allColumnsExpr() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASTERISK:{
      jj_consume_token(ASTERISK);
      break;
      }
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case ALL:
    case AND:
    case APPLY:
    case ARRAY:
    case AS:
    case ASOF:
    case BETWEEN:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FINAL:
    case FORMAT:
    case FROM:
    case FULL:
    case FUNCTION:
    case GLOBAL:
    case GROUP:
    case HAVING:
    case IF:
    case ILIKE:
    case IN:
    case INNER:
    case INTERVAL:
    case INTO:
    case IS:
    case JOIN:
    case LEFT:
    case LIKE:
    case LIMIT:
    case LIVE:
    case MATERIALIZED:
    case NOT:
    case OFFSET:
    case ON:
    case OR:
    case ORDER:
    case OUTFILE:
    case POLICY:
    case PREWHERE:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case RIGHT:
    case SAMPLE:
    case SETTINGS:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case UNION:
    case USER:
    case USING:
    case VALUES:
    case VIEW:
    case WHEN:
    case WHERE:
    case WITH:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:
    case AT:
    case IDENTIFIER:
    case BACK_QUOTED_NAME:
    case DOUBLE_QUOTED_NAME:{
      anyIdentifier();
      jj_consume_token(DOT);
      if (jj_2_80(2)) {
        anyIdentifier();
        jj_consume_token(DOT);
      } else {
        ;
      }
      jj_consume_token(ASTERISK);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void nestedExpr() throws ParseException {
    if (jj_2_92(2)) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DASH:{
        jj_consume_token(DASH);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      nestedExpr();
    } else if (jj_2_93(2)) {
      jj_consume_token(CASE);
      if (getToken(1).kind != WHEN) {
        nestedExpr();
      } else {
        ;
      }
      label_14:
      while (true) {
        jj_consume_token(WHEN);
        nestedExpr();
        jj_consume_token(THEN);
        nestedExpr();
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case WHEN:{
          break;
          }
        default:
          break label_14;
        }
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ELSE:{
        jj_consume_token(ELSE);
        nestedExpr();
        break;
        }
      default:
        ;
      }
      jj_consume_token(END);
    } else if (jj_2_94(2)) {
      jj_consume_token(INTERVAL);
      if (jj_2_81(2)) {
        jj_consume_token(STRING_LITERAL);
      } else if (jj_2_82(1)) {
        nestedExpr();
        interval();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_95(1)) {
      columnExpr();
      if (jj_2_91(1)) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case DOT:
        case FLOATING_LITERAL:{
          label_15:
          while (true) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case FLOATING_LITERAL:{
              jj_consume_token(FLOATING_LITERAL);
              break;
              }
            case DOT:{
              jj_consume_token(DOT);
              jj_consume_token(DECIMAL_LITERAL);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case DOT:
            case FLOATING_LITERAL:{
              break;
              }
            default:
              break label_15;
            }
          }
          break;
          }
        case LBRACKET:{
          label_16:
          while (true) {
            jj_consume_token(LBRACKET);
            anyExprList();
            jj_consume_token(RBRACKET);
            if (jj_2_83(2)) {
            } else {
              break label_16;
            }
          }
          break;
          }
        default:
          if (jj_2_85(2)) {
            jj_consume_token(IS);
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            jj_consume_token(NULL);
          } else if (jj_2_86(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            betweenExpr();
          } else if (jj_2_87(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case ILIKE:{
              jj_consume_token(ILIKE);
              break;
              }
            case LIKE:{
              jj_consume_token(LIKE);
              break;
              }
            default:
              jj_consume_token(-1);
              throw new ParseException();
            }
            nestedExpr();
          } else if (jj_2_88(2) && (noAndWithinBetween())) {
            label_17:
            while (true) {
              calcExpr();
              if (jj_2_84(2) && (noAndWithinBetween())) {
              } else {
                break label_17;
              }
            }
          } else if (jj_2_89(2)) {
            switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
            case NOT:{
              jj_consume_token(NOT);
              break;
              }
            default:
              ;
            }
            jj_consume_token(IN);
            nestedExpr();
          } else if (jj_2_90(2)) {
            jj_consume_token(QUERY);
            nestedExpr();
            jj_consume_token(COLON);
            nestedExpr();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void calcExpr() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case AND:{
      jj_consume_token(AND);
      break;
      }
    case OR:{
      jj_consume_token(OR);
      break;
      }
    case ARROW:
    case ASTERISK:
    case CONCAT:
    case DASH:
    case EQ_DOUBLE:
    case EQ_SINGLE:
    case GE:
    case GT:
    case LE:
    case LT:
    case NOT_EQ:
    case PERCENT:
    case PLUS:
    case SLASH:{
      operator();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    nestedExpr();
}

  final public void betweenExpr() throws ParseException {
    jj_consume_token(BETWEEN);
token_source.enterToken(BETWEEN);
    nestedExpr();
    jj_consume_token(AND);
token_source.leaveToken(BETWEEN);
    nestedExpr();
}

  final public void functionExpr() throws ParseException {
    anyIdentifier();
    jj_consume_token(LPAREN);
    if (jj_2_96(1)) {
      anyExprList();
    } else {
      ;
    }
    jj_consume_token(RPAREN);
    if (jj_2_98(2)) {
      jj_consume_token(LPAREN);
      if (jj_2_97(1)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } else {
      ;
    }
}

  final public void columnExpr() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case QUERY:{
      t = jj_consume_token(QUERY);
token_source.processParameter(t.image, handler);
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      if (jj_2_99(2)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RBRACE);
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      if (jj_2_100(2)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RBRACKET);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      anyExprList();
      jj_consume_token(RPAREN);
      break;
      }
    case HASH:{
      label_18:
      while (true) {
        macro();
        if (jj_2_101(2)) {
        } else {
          break label_18;
        }
      }
      break;
      }
    default:
      if (jj_2_103(2) && (!(tokenIn(1, INF, NAN, NULL) && tokenIn(2, DOT)))) {
        literal();
      } else if (jj_2_104(2) && (getToken(2).kind == LPAREN)) {
        functionExpr();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALTER:
        case ATTACH:
        case CHECK:
        case CREATE:
        case DELETE:
        case DESC:
        case DESCRIBE:
        case DETACH:
        case DROP:
        case EXISTS:
        case EXPLAIN:
        case GRANT:
        case INSERT:
        case KILL:
        case OPTIMIZE:
        case RENAME:
        case REVOKE:
        case SELECT:
        case SET:
        case SHOW:
        case SYSTEM:
        case TRUNCATE:
        case UPDATE:
        case USE:
        case WATCH:
        case ALL:
        case AND:
        case APPLY:
        case ARRAY:
        case AS:
        case ASOF:
        case BETWEEN:
        case CASE:
        case CLUSTER:
        case DATE:
        case DATABASE:
        case DATABASES:
        case DICTIONARY:
        case DICTIONARIES:
        case DISTINCT:
        case ELSE:
        case END:
        case EXCEPT:
        case FINAL:
        case FORMAT:
        case FROM:
        case FULL:
        case FUNCTION:
        case GLOBAL:
        case GROUP:
        case HAVING:
        case IF:
        case ILIKE:
        case IN:
        case INNER:
        case INTERVAL:
        case INTO:
        case IS:
        case JOIN:
        case LEFT:
        case LIKE:
        case LIMIT:
        case LIVE:
        case MATERIALIZED:
        case NOT:
        case OFFSET:
        case ON:
        case OR:
        case ORDER:
        case OUTFILE:
        case POLICY:
        case PREWHERE:
        case PROFILE:
        case QUOTA:
        case REPLACE:
        case ROLE:
        case ROW:
        case RIGHT:
        case SAMPLE:
        case SETTINGS:
        case TEMPORARY:
        case TABLE:
        case TABLES:
        case THEN:
        case TIES:
        case TIMESTAMP:
        case TOP:
        case TOTALS:
        case UNION:
        case USER:
        case USING:
        case VALUES:
        case VIEW:
        case WHEN:
        case WHERE:
        case WITH:
        case SECOND:
        case MINUTE:
        case HOUR:
        case DAY:
        case WEEK:
        case MONTH:
        case QUARTER:
        case YEAR:
        case INF:
        case NAN:
        case NULL:
        case AT:
        case IDENTIFIER:
        case BACK_QUOTED_NAME:
        case DOUBLE_QUOTED_NAME:{
          anyIdentifier();
          label_19:
          while (true) {
            if (jj_2_102(2)) {
            } else {
              break label_19;
            }
            jj_consume_token(DOT);
            anyIdentifier();
          }
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

// interested parts
  final public void formatPart() throws ParseException {Token t;
    jj_consume_token(FORMAT);
    if (jj_2_105(2)) {
      t = jj_consume_token(IDENTIFIER);
token_source.format = t.image;
    } else {
      ;
    }
}

  final public void outfilePart() throws ParseException {Token t;
    jj_consume_token(INTO);
    jj_consume_token(OUTFILE);
    if (jj_2_106(2)) {
      t = jj_consume_token(STRING_LITERAL);
token_source.outfile = t.image;
    } else {
      ;
    }
}

  final public void withTotalPart() throws ParseException {Token t;
    jj_consume_token(WITH);
    if (jj_2_107(2)) {
      t = jj_consume_token(TOTALS);
token_source.setPosition(t.image);
    } else {
      ;
    }
}

// expressions
  final public void anyExprList() throws ParseException {
    anyExpr();
    label_20:
    while (true) {
      if (jj_2_108(1)) {
      } else {
        break label_20;
      }
      if (jj_2_109(2)) {
        jj_consume_token(COMMA);
      } else if (jj_2_110(1)) {
        anyExpr();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void anyExpr() throws ParseException {
    anyNestedExpr();
    label_21:
    while (true) {
      if (jj_2_111(2)) {
      } else {
        break label_21;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:
      case OR:
      case ARROW:
      case ASTERISK:
      case AT:
      case COLON:
      case CONCAT:
      case DASH:
      case EQ_DOUBLE:
      case EQ_SINGLE:
      case GE:
      case GT:
      case LE:
      case LT:
      case NOT_EQ:
      case PERCENT:
      case PLUS:
      case QUERY:
      case SLASH:{
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case AT:{
          jj_consume_token(AT);
          break;
          }
        case AND:{
          jj_consume_token(AND);
          break;
          }
        case OR:{
          jj_consume_token(OR);
          break;
          }
        case COLON:{
          jj_consume_token(COLON);
          break;
          }
        case QUERY:{
          jj_consume_token(QUERY);
          break;
          }
        case ARROW:
        case ASTERISK:
        case CONCAT:
        case DASH:
        case EQ_DOUBLE:
        case EQ_SINGLE:
        case GE:
        case GT:
        case LE:
        case LT:
        case NOT_EQ:
        case PERCENT:
        case PLUS:
        case SLASH:{
          operator();
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        ;
      }
      anyNestedExpr();
    }
}

  final public void anyNestedExpr() throws ParseException {
    if (jj_2_114(2)) {
      formatPart();
    } else if (jj_2_115(2)) {
      withTotalPart();
    } else if (jj_2_116(2)) {
      outfilePart();
    } else if (jj_2_117(1)) {
      if (jj_2_112(2)) {
        jj_consume_token(DASH);
      } else {
        ;
      }
      anyColumnExpr();
      label_22:
      while (true) {
        if (jj_2_113(1)) {
        } else {
          break label_22;
        }
        if (getToken(1).kind == FLOATING_LITERAL) {
          jj_consume_token(FLOATING_LITERAL);
        } else {
          switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
          case DOT:{
            jj_consume_token(DOT);
            jj_consume_token(DECIMAL_LITERAL);
            break;
            }
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void anyColumnExpr() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case QUERY:{
      // <ASTERISK>
          t = jj_consume_token(QUERY);
token_source.processParameter(t.image, handler);
      break;
      }
    case LBRACE:{
      jj_consume_token(LBRACE);
      if (jj_2_118(2)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RBRACE);
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      if (jj_2_119(2)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RBRACKET);
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
      if (jj_2_120(2)) {
        anyExprList();
      } else {
        ;
      }
      jj_consume_token(RPAREN);
      break;
      }
    case HASH:{
      label_23:
      while (true) {
        macro();
        if (jj_2_121(2)) {
        } else {
          break label_23;
        }
      }
      break;
      }
    default:
      if (jj_2_122(2) && (!(tokenIn(1, INF, NAN, NULL) && tokenIn(2, DOT)))) {
        literal();
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case ALTER:
        case ATTACH:
        case CHECK:
        case CREATE:
        case DELETE:
        case DESC:
        case DESCRIBE:
        case DETACH:
        case DROP:
        case EXISTS:
        case EXPLAIN:
        case GRANT:
        case INSERT:
        case KILL:
        case OPTIMIZE:
        case RENAME:
        case REVOKE:
        case SELECT:
        case SET:
        case SHOW:
        case SYSTEM:
        case TRUNCATE:
        case UPDATE:
        case USE:
        case WATCH:
        case ALL:
        case AND:
        case APPLY:
        case ARRAY:
        case AS:
        case ASOF:
        case BETWEEN:
        case CASE:
        case CLUSTER:
        case DATE:
        case DATABASE:
        case DATABASES:
        case DICTIONARY:
        case DICTIONARIES:
        case DISTINCT:
        case ELSE:
        case END:
        case EXCEPT:
        case FINAL:
        case FORMAT:
        case FROM:
        case FULL:
        case FUNCTION:
        case GLOBAL:
        case GROUP:
        case HAVING:
        case IF:
        case ILIKE:
        case IN:
        case INNER:
        case INTERVAL:
        case INTO:
        case IS:
        case JOIN:
        case LEFT:
        case LIKE:
        case LIMIT:
        case LIVE:
        case MATERIALIZED:
        case NOT:
        case OFFSET:
        case ON:
        case OR:
        case ORDER:
        case OUTFILE:
        case POLICY:
        case PREWHERE:
        case PROFILE:
        case QUOTA:
        case REPLACE:
        case ROLE:
        case ROW:
        case RIGHT:
        case SAMPLE:
        case SETTINGS:
        case TEMPORARY:
        case TABLE:
        case TABLES:
        case THEN:
        case TIES:
        case TIMESTAMP:
        case TOP:
        case TOTALS:
        case UNION:
        case USER:
        case USING:
        case VALUES:
        case VIEW:
        case WHEN:
        case WHERE:
        case WITH:
        case SECOND:
        case MINUTE:
        case HOUR:
        case DAY:
        case WEEK:
        case MONTH:
        case QUARTER:
        case YEAR:
        case INF:
        case NAN:
        case NULL:
        case ASTERISK:
        case AT:
        case IDENTIFIER:
        case BACK_QUOTED_NAME:
        case DOUBLE_QUOTED_NAME:{
          nestedIdentifier();
          break;
          }
        default:
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
}

  final public Token aliasExpr() throws ParseException {Token t = null;
    if (jj_2_123(2)) {
      jj_consume_token(AS);
      t = anyIdentifier();
    } else if (jj_2_124(2)) {
      formatPart();
    } else if (jj_2_125(2)) {
      outfilePart();
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ALTER:
      case ATTACH:
      case CHECK:
      case CREATE:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DETACH:
      case DROP:
      case EXISTS:
      case EXPLAIN:
      case GRANT:
      case INSERT:
      case KILL:
      case OPTIMIZE:
      case RENAME:
      case REVOKE:
      case SELECT:
      case SET:
      case SHOW:
      case SYSTEM:
      case TRUNCATE:
      case UPDATE:
      case USE:
      case WATCH:
      case CASE:
      case CLUSTER:
      case DATE:
      case DATABASE:
      case DATABASES:
      case DICTIONARY:
      case DICTIONARIES:
      case DISTINCT:
      case ELSE:
      case END:
      case EXCEPT:
      case FUNCTION:
      case IF:
      case INTERVAL:
      case IS:
      case LIVE:
      case MATERIALIZED:
      case OUTFILE:
      case POLICY:
      case PROFILE:
      case QUOTA:
      case REPLACE:
      case ROLE:
      case ROW:
      case TEMPORARY:
      case TABLE:
      case TABLES:
      case THEN:
      case TIES:
      case TIMESTAMP:
      case TOP:
      case TOTALS:
      case USER:
      case VALUES:
      case VIEW:
      case WHEN:
      case SECOND:
      case MINUTE:
      case HOUR:
      case DAY:
      case WEEK:
      case MONTH:
      case QUARTER:
      case YEAR:
      case INF:
      case NAN:
      case NULL:
      case AT:
      case IDENTIFIER:
      case BACK_QUOTED_NAME:
      case DOUBLE_QUOTED_NAME:{
        t = identifier();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void nestedIdentifier() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ASTERISK:{
      jj_consume_token(ASTERISK);
      break;
      }
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case ALL:
    case AND:
    case APPLY:
    case ARRAY:
    case AS:
    case ASOF:
    case BETWEEN:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FINAL:
    case FORMAT:
    case FROM:
    case FULL:
    case FUNCTION:
    case GLOBAL:
    case GROUP:
    case HAVING:
    case IF:
    case ILIKE:
    case IN:
    case INNER:
    case INTERVAL:
    case INTO:
    case IS:
    case JOIN:
    case LEFT:
    case LIKE:
    case LIMIT:
    case LIVE:
    case MATERIALIZED:
    case NOT:
    case OFFSET:
    case ON:
    case OR:
    case ORDER:
    case OUTFILE:
    case POLICY:
    case PREWHERE:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case RIGHT:
    case SAMPLE:
    case SETTINGS:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case UNION:
    case USER:
    case USING:
    case VALUES:
    case VIEW:
    case WHEN:
    case WHERE:
    case WITH:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:
    case AT:
    case IDENTIFIER:
    case BACK_QUOTED_NAME:
    case DOUBLE_QUOTED_NAME:{
      anyIdentifier();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_24:
    while (true) {
      if (jj_2_126(2)) {
      } else {
        break label_24;
      }
      jj_consume_token(DOT);
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case ASTERISK:{
        jj_consume_token(ASTERISK);
        break;
        }
      case ALTER:
      case ATTACH:
      case CHECK:
      case CREATE:
      case DELETE:
      case DESC:
      case DESCRIBE:
      case DETACH:
      case DROP:
      case EXISTS:
      case EXPLAIN:
      case GRANT:
      case INSERT:
      case KILL:
      case OPTIMIZE:
      case RENAME:
      case REVOKE:
      case SELECT:
      case SET:
      case SHOW:
      case SYSTEM:
      case TRUNCATE:
      case UPDATE:
      case USE:
      case WATCH:
      case ALL:
      case AND:
      case APPLY:
      case ARRAY:
      case AS:
      case ASOF:
      case BETWEEN:
      case CASE:
      case CLUSTER:
      case DATE:
      case DATABASE:
      case DATABASES:
      case DICTIONARY:
      case DICTIONARIES:
      case DISTINCT:
      case ELSE:
      case END:
      case EXCEPT:
      case FINAL:
      case FORMAT:
      case FROM:
      case FULL:
      case FUNCTION:
      case GLOBAL:
      case GROUP:
      case HAVING:
      case IF:
      case ILIKE:
      case IN:
      case INNER:
      case INTERVAL:
      case INTO:
      case IS:
      case JOIN:
      case LEFT:
      case LIKE:
      case LIMIT:
      case LIVE:
      case MATERIALIZED:
      case NOT:
      case OFFSET:
      case ON:
      case OR:
      case ORDER:
      case OUTFILE:
      case POLICY:
      case PREWHERE:
      case PROFILE:
      case QUOTA:
      case REPLACE:
      case ROLE:
      case ROW:
      case RIGHT:
      case SAMPLE:
      case SETTINGS:
      case TEMPORARY:
      case TABLE:
      case TABLES:
      case THEN:
      case TIES:
      case TIMESTAMP:
      case TOP:
      case TOTALS:
      case UNION:
      case USER:
      case USING:
      case VALUES:
      case VIEW:
      case WHEN:
      case WHERE:
      case WITH:
      case SECOND:
      case MINUTE:
      case HOUR:
      case DAY:
      case WEEK:
      case MONTH:
      case QUARTER:
      case YEAR:
      case INF:
      case NAN:
      case NULL:
      case AT:
      case IDENTIFIER:
      case BACK_QUOTED_NAME:
      case DOUBLE_QUOTED_NAME:{
        anyIdentifier();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
}

  final public void tableIdentifier(boolean record) throws ParseException {Token t;
    if (jj_2_127(2)) {
      databaseIdentifier(record);
      jj_consume_token(DOT);
    } else {
      ;
    }
    t = anyIdentifier();
    if (jj_2_128(2)) {
      jj_consume_token(LPAREN);
      anyExprList();
      jj_consume_token(RPAREN);
    } else {
      ;
    }
if (record && t != null && token_source.table == null) {
            token_source.table = ClickHouseSqlUtils.unescape(t.image);
        }
}

  final public void databaseIdentifier(boolean record) throws ParseException {Token t;
    t = anyIdentifier();
if (record) token_source.database = ClickHouseSqlUtils.unescape(t.image);
}

  final public void settingExprList() throws ParseException {
    settingExpr();
    label_25:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case COMMA:{
        break;
        }
      default:
        break label_25;
      }
      jj_consume_token(COMMA);
      settingExpr();
    }
}

  final public void settingExpr() throws ParseException {
    identifier();
    jj_consume_token(EQ_SINGLE);
    literal();
}

// basics
  final public Token anyIdentifier() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BACK_QUOTED_NAME:{
      t = jj_consume_token(BACK_QUOTED_NAME);
      break;
      }
    case DOUBLE_QUOTED_NAME:{
      t = jj_consume_token(DOUBLE_QUOTED_NAME);
      break;
      }
    case AT:{
      t = variable();
      break;
      }
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case ALL:
    case AND:
    case APPLY:
    case ARRAY:
    case AS:
    case ASOF:
    case BETWEEN:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FINAL:
    case FORMAT:
    case FROM:
    case FULL:
    case FUNCTION:
    case GLOBAL:
    case GROUP:
    case HAVING:
    case IF:
    case ILIKE:
    case IN:
    case INNER:
    case INTERVAL:
    case INTO:
    case IS:
    case JOIN:
    case LEFT:
    case LIKE:
    case LIMIT:
    case LIVE:
    case MATERIALIZED:
    case NOT:
    case OFFSET:
    case ON:
    case OR:
    case ORDER:
    case OUTFILE:
    case POLICY:
    case PREWHERE:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case RIGHT:
    case SAMPLE:
    case SETTINGS:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case UNION:
    case USER:
    case USING:
    case VALUES:
    case VIEW:
    case WHEN:
    case WHERE:
    case WITH:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:{
      t = anyKeyword();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token identifier() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BACK_QUOTED_NAME:{
      t = jj_consume_token(BACK_QUOTED_NAME);
      break;
      }
    case DOUBLE_QUOTED_NAME:{
      t = jj_consume_token(DOUBLE_QUOTED_NAME);
      break;
      }
    case AT:{
      t = variable();
      break;
      }
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FUNCTION:
    case IF:
    case INTERVAL:
    case IS:
    case LIVE:
    case MATERIALIZED:
    case OUTFILE:
    case POLICY:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case USER:
    case VALUES:
    case VIEW:
    case WHEN:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:{
      t = keyword();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void interval() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case SECOND:{
      jj_consume_token(SECOND);
      break;
      }
    case MINUTE:{
      jj_consume_token(MINUTE);
      break;
      }
    case HOUR:{
      jj_consume_token(HOUR);
      break;
      }
    case DAY:{
      jj_consume_token(DAY);
      break;
      }
    case WEEK:{
      jj_consume_token(WEEK);
      break;
      }
    case MONTH:{
      jj_consume_token(MONTH);
      break;
      }
    case QUARTER:{
      jj_consume_token(QUARTER);
      break;
      }
    case YEAR:{
      jj_consume_token(YEAR);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public Token literal() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATE:
    case TIMESTAMP:{
      t = dateLiteral();
      break;
      }
    case INF:
    case NAN:
    case DASH:
    case PLUS:
    case FLOATING_LITERAL:
    case DECIMAL_LITERAL:
    case HEXADECIMAL_LITERAL:{
      t = numberLiteral();
      break;
      }
    case STRING_LITERAL:{
      t = jj_consume_token(STRING_LITERAL);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token dateLiteral() throws ParseException {Token t; String prefix;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DATE:{
      t = jj_consume_token(DATE);
      break;
      }
    case TIMESTAMP:{
      t = jj_consume_token(TIMESTAMP);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
prefix = t.image;
    t = jj_consume_token(STRING_LITERAL);
{if ("" != null) return Token.newToken(0, prefix + " " + t.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token numberLiteral() throws ParseException {Token t = null; StringBuilder sb = new StringBuilder();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case DASH:
    case PLUS:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case PLUS:{
        t = jj_consume_token(PLUS);
        break;
        }
      case DASH:{
        t = jj_consume_token(DASH);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      ;
    }
if (t != null) sb.append(t.image);
    if (jj_2_129(2)) {
      t = jj_consume_token(DECIMAL_LITERAL);
    } else {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case HEXADECIMAL_LITERAL:{
        t = jj_consume_token(HEXADECIMAL_LITERAL);
        break;
        }
      case FLOATING_LITERAL:{
        t = jj_consume_token(FLOATING_LITERAL);
        break;
        }
      case INF:{
        t = jj_consume_token(INF);
        break;
        }
      case NAN:{
        t = jj_consume_token(NAN);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
sb.append(t.image);
{if ("" != null) return Token.newToken(0, sb.toString());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void operator() throws ParseException {
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ARROW:{
      jj_consume_token(ARROW);
      break;
      }
    case ASTERISK:{
      jj_consume_token(ASTERISK);
      break;
      }
    case CONCAT:{
      jj_consume_token(CONCAT);
      break;
      }
    case DASH:{
      jj_consume_token(DASH);
      break;
      }
    case EQ_DOUBLE:{
      jj_consume_token(EQ_DOUBLE);
      break;
      }
    case EQ_SINGLE:{
      jj_consume_token(EQ_SINGLE);
      break;
      }
    case GE:{
      jj_consume_token(GE);
      break;
      }
    case GT:{
      jj_consume_token(GT);
      break;
      }
    case LE:{
      jj_consume_token(LE);
      break;
      }
    case LT:{
      jj_consume_token(LT);
      break;
      }
    case NOT_EQ:{
      jj_consume_token(NOT_EQ);
      break;
      }
    case PERCENT:{
      jj_consume_token(PERCENT);
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
      break;
      }
    case SLASH:{
      jj_consume_token(SLASH);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public void macro() throws ParseException {Token t;
    String name;
    List<String> params = new ArrayList<>();
    jj_consume_token(HASH);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case ALL:
    case AND:
    case APPLY:
    case ARRAY:
    case AS:
    case ASOF:
    case BETWEEN:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FINAL:
    case FORMAT:
    case FROM:
    case FULL:
    case FUNCTION:
    case GLOBAL:
    case GROUP:
    case HAVING:
    case IF:
    case ILIKE:
    case IN:
    case INNER:
    case INTERVAL:
    case INTO:
    case IS:
    case JOIN:
    case LEFT:
    case LIKE:
    case LIMIT:
    case LIVE:
    case MATERIALIZED:
    case NOT:
    case OFFSET:
    case ON:
    case OR:
    case ORDER:
    case OUTFILE:
    case POLICY:
    case PREWHERE:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case RIGHT:
    case SAMPLE:
    case SETTINGS:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case UNION:
    case USER:
    case USING:
    case VALUES:
    case VIEW:
    case WHEN:
    case WHERE:
    case WITH:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:{
      t = anyKeyword();
      break;
      }
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
name = t.image;
    if (jj_2_130(2)) {
      jj_consume_token(LPAREN);
      t = jj_consume_token(STRING_LITERAL);
params.add(ClickHouseSqlUtils.unescape(t.image));
      label_26:
      while (true) {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case COMMA:{
          break;
          }
        default:
          break label_26;
        }
        jj_consume_token(COMMA);
        t = jj_consume_token(STRING_LITERAL);
params.add(ClickHouseSqlUtils.unescape(t.image));
      }
      jj_consume_token(RPAREN);
    } else {
      ;
    }
token_source.processMacro(name, params, handler);
}

  final public Token variable() throws ParseException {Token t;
    jj_consume_token(AT);
    jj_consume_token(AT);
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:
    case ATTACH:
    case CHECK:
    case CREATE:
    case DELETE:
    case DESC:
    case DESCRIBE:
    case DETACH:
    case DROP:
    case EXISTS:
    case EXPLAIN:
    case GRANT:
    case INSERT:
    case KILL:
    case OPTIMIZE:
    case RENAME:
    case REVOKE:
    case SELECT:
    case SET:
    case SHOW:
    case SYSTEM:
    case TRUNCATE:
    case UPDATE:
    case USE:
    case WATCH:
    case ALL:
    case AND:
    case APPLY:
    case ARRAY:
    case AS:
    case ASOF:
    case BETWEEN:
    case CASE:
    case CLUSTER:
    case DATE:
    case DATABASE:
    case DATABASES:
    case DICTIONARY:
    case DICTIONARIES:
    case DISTINCT:
    case ELSE:
    case END:
    case EXCEPT:
    case FINAL:
    case FORMAT:
    case FROM:
    case FULL:
    case FUNCTION:
    case GLOBAL:
    case GROUP:
    case HAVING:
    case IF:
    case ILIKE:
    case IN:
    case INNER:
    case INTERVAL:
    case INTO:
    case IS:
    case JOIN:
    case LEFT:
    case LIKE:
    case LIMIT:
    case LIVE:
    case MATERIALIZED:
    case NOT:
    case OFFSET:
    case ON:
    case OR:
    case ORDER:
    case OUTFILE:
    case POLICY:
    case PREWHERE:
    case PROFILE:
    case QUOTA:
    case REPLACE:
    case ROLE:
    case ROW:
    case RIGHT:
    case SAMPLE:
    case SETTINGS:
    case TEMPORARY:
    case TABLE:
    case TABLES:
    case THEN:
    case TIES:
    case TIMESTAMP:
    case TOP:
    case TOTALS:
    case UNION:
    case USER:
    case USING:
    case VALUES:
    case VIEW:
    case WHEN:
    case WHERE:
    case WITH:
    case SECOND:
    case MINUTE:
    case HOUR:
    case DAY:
    case WEEK:
    case MONTH:
    case QUARTER:
    case YEAR:
    case INF:
    case NAN:
    case NULL:{
      t = anyKeyword();
      break;
      }
    case IDENTIFIER:{
      t = jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return Token.newToken(0, "@@" + t.image);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token anyKeyword() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:{
      // leading keywords(except with)
              t = jj_consume_token(ALTER);
      break;
      }
    case ATTACH:{
      t = jj_consume_token(ATTACH);
      break;
      }
    case CHECK:{
      t = jj_consume_token(CHECK);
      break;
      }
    case CREATE:{
      t = jj_consume_token(CREATE);
      break;
      }
    case DELETE:{
      t = jj_consume_token(DELETE);
      break;
      }
    case DESC:{
      t = jj_consume_token(DESC);
      break;
      }
    case DESCRIBE:{
      t = jj_consume_token(DESCRIBE);
      break;
      }
    case DETACH:{
      t = jj_consume_token(DETACH);
      break;
      }
    case DROP:{
      t = jj_consume_token(DROP);
      break;
      }
    case EXISTS:{
      t = jj_consume_token(EXISTS);
      break;
      }
    case EXPLAIN:{
      t = jj_consume_token(EXPLAIN);
      break;
      }
    case GRANT:{
      t = jj_consume_token(GRANT);
      break;
      }
    case INSERT:{
      t = jj_consume_token(INSERT);
      break;
      }
    case KILL:{
      t = jj_consume_token(KILL);
      break;
      }
    case OPTIMIZE:{
      t = jj_consume_token(OPTIMIZE);
      break;
      }
    case RENAME:{
      t = jj_consume_token(RENAME);
      break;
      }
    case REVOKE:{
      t = jj_consume_token(REVOKE);
      break;
      }
    case SELECT:{
      t = jj_consume_token(SELECT);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    case SHOW:{
      t = jj_consume_token(SHOW);
      break;
      }
    case SYSTEM:{
      t = jj_consume_token(SYSTEM);
      break;
      }
    case TRUNCATE:{
      t = jj_consume_token(TRUNCATE);
      break;
      }
    case UPDATE:{
      t = jj_consume_token(UPDATE);
      break;
      }
    case USE:{
      t = jj_consume_token(USE);
      break;
      }
    case WATCH:{
      t = jj_consume_token(WATCH);
      break;
      }
    case ALL:{
      t = jj_consume_token(ALL);
      break;
      }
    case AND:{
      t = jj_consume_token(AND);
      break;
      }
    case APPLY:{
      t = jj_consume_token(APPLY);
      break;
      }
    case ARRAY:{
      t = jj_consume_token(ARRAY);
      break;
      }
    case AS:{
      t = jj_consume_token(AS);
      break;
      }
    case ASOF:{
      t = jj_consume_token(ASOF);
      break;
      }
    case BETWEEN:{
      t = jj_consume_token(BETWEEN);
      break;
      }
    case CASE:{
      t = jj_consume_token(CASE);
      break;
      }
    case CLUSTER:{
      t = jj_consume_token(CLUSTER);
      break;
      }
    case DATE:{
      t = jj_consume_token(DATE);
      break;
      }
    case DATABASE:{
      t = jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      t = jj_consume_token(DATABASES);
      break;
      }
    case DICTIONARY:{
      t = jj_consume_token(DICTIONARY);
      break;
      }
    case DICTIONARIES:{
      t = jj_consume_token(DICTIONARIES);
      break;
      }
    case DISTINCT:{
      t = jj_consume_token(DISTINCT);
      break;
      }
    case ELSE:{
      t = jj_consume_token(ELSE);
      break;
      }
    case END:{
      t = jj_consume_token(END);
      break;
      }
    case EXCEPT:{
      t = jj_consume_token(EXCEPT);
      break;
      }
    case FORMAT:{
      t = jj_consume_token(FORMAT);
      break;
      }
    case FROM:{
      t = jj_consume_token(FROM);
      break;
      }
    case FINAL:{
      t = jj_consume_token(FINAL);
      break;
      }
    case FULL:{
      t = jj_consume_token(FULL);
      break;
      }
    case FUNCTION:{
      t = jj_consume_token(FUNCTION);
      break;
      }
    case GLOBAL:{
      t = jj_consume_token(GLOBAL);
      break;
      }
    case GROUP:{
      t = jj_consume_token(GROUP);
      break;
      }
    case HAVING:{
      t = jj_consume_token(HAVING);
      break;
      }
    case IF:{
      t = jj_consume_token(IF);
      break;
      }
    case ILIKE:{
      t = jj_consume_token(ILIKE);
      break;
      }
    case IN:{
      t = jj_consume_token(IN);
      break;
      }
    case INNER:{
      t = jj_consume_token(INNER);
      break;
      }
    case INTERVAL:{
      t = jj_consume_token(INTERVAL);
      break;
      }
    case INTO:{
      t = jj_consume_token(INTO);
      break;
      }
    case IS:{
      t = jj_consume_token(IS);
      break;
      }
    case JOIN:{
      t = jj_consume_token(JOIN);
      break;
      }
    case LEFT:{
      t = jj_consume_token(LEFT);
      break;
      }
    case LIKE:{
      t = jj_consume_token(LIKE);
      break;
      }
    case LIMIT:{
      t = jj_consume_token(LIMIT);
      break;
      }
    case LIVE:{
      t = jj_consume_token(LIVE);
      break;
      }
    case MATERIALIZED:{
      t = jj_consume_token(MATERIALIZED);
      break;
      }
    case NOT:{
      t = jj_consume_token(NOT);
      break;
      }
    case OFFSET:{
      t = jj_consume_token(OFFSET);
      break;
      }
    case ON:{
      t = jj_consume_token(ON);
      break;
      }
    case OR:{
      t = jj_consume_token(OR);
      break;
      }
    case ORDER:{
      t = jj_consume_token(ORDER);
      break;
      }
    case OUTFILE:{
      t = jj_consume_token(OUTFILE);
      break;
      }
    case POLICY:{
      t = jj_consume_token(POLICY);
      break;
      }
    case PREWHERE:{
      t = jj_consume_token(PREWHERE);
      break;
      }
    case PROFILE:{
      t = jj_consume_token(PROFILE);
      break;
      }
    case QUOTA:{
      t = jj_consume_token(QUOTA);
      break;
      }
    case REPLACE:{
      t = jj_consume_token(REPLACE);
      break;
      }
    case RIGHT:{
      t = jj_consume_token(RIGHT);
      break;
      }
    case ROLE:{
      t = jj_consume_token(ROLE);
      break;
      }
    case ROW:{
      t = jj_consume_token(ROW);
      break;
      }
    case SAMPLE:{
      t = jj_consume_token(SAMPLE);
      break;
      }
    case SETTINGS:{
      t = jj_consume_token(SETTINGS);
      break;
      }
    case TEMPORARY:{
      t = jj_consume_token(TEMPORARY);
      break;
      }
    case TABLE:{
      t = jj_consume_token(TABLE);
      break;
      }
    case TABLES:{
      t = jj_consume_token(TABLES);
      break;
      }
    case THEN:{
      t = jj_consume_token(THEN);
      break;
      }
    case TIES:{
      t = jj_consume_token(TIES);
      break;
      }
    case TIMESTAMP:{
      t = jj_consume_token(TIMESTAMP);
      break;
      }
    case TOP:{
      t = jj_consume_token(TOP);
      break;
      }
    case TOTALS:{
      t = jj_consume_token(TOTALS);
      break;
      }
    case VALUES:{
      t = jj_consume_token(VALUES);
      break;
      }
    case VIEW:{
      t = jj_consume_token(VIEW);
      break;
      }
    case USER:{
      t = jj_consume_token(USER);
      break;
      }
    case UNION:{
      t = jj_consume_token(UNION);
      break;
      }
    case USING:{
      t = jj_consume_token(USING);
      break;
      }
    case WHEN:{
      t = jj_consume_token(WHEN);
      break;
      }
    case WHERE:{
      t = jj_consume_token(WHERE);
      break;
      }
    case WITH:{
      t = jj_consume_token(WITH);
      break;
      }
    case SECOND:{
      t = jj_consume_token(SECOND);
      break;
      }
    case MINUTE:{
      t = jj_consume_token(MINUTE);
      break;
      }
    case HOUR:{
      t = jj_consume_token(HOUR);
      break;
      }
    case DAY:{
      t = jj_consume_token(DAY);
      break;
      }
    case WEEK:{
      t = jj_consume_token(WEEK);
      break;
      }
    case MONTH:{
      t = jj_consume_token(MONTH);
      break;
      }
    case QUARTER:{
      t = jj_consume_token(QUARTER);
      break;
      }
    case YEAR:{
      t = jj_consume_token(YEAR);
      break;
      }
    case INF:{
      t = jj_consume_token(INF);
      break;
      }
    case NAN:{
      t = jj_consume_token(NAN);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Token keyword() throws ParseException {Token t;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case ALTER:{
      // leading keywords(except with)
              t = jj_consume_token(ALTER);
      break;
      }
    case ATTACH:{
      t = jj_consume_token(ATTACH);
      break;
      }
    case CHECK:{
      t = jj_consume_token(CHECK);
      break;
      }
    case CREATE:{
      t = jj_consume_token(CREATE);
      break;
      }
    case DELETE:{
      t = jj_consume_token(DELETE);
      break;
      }
    case DESC:{
      t = jj_consume_token(DESC);
      break;
      }
    case DESCRIBE:{
      t = jj_consume_token(DESCRIBE);
      break;
      }
    case DETACH:{
      t = jj_consume_token(DETACH);
      break;
      }
    case DROP:{
      t = jj_consume_token(DROP);
      break;
      }
    case EXISTS:{
      t = jj_consume_token(EXISTS);
      break;
      }
    case EXPLAIN:{
      t = jj_consume_token(EXPLAIN);
      break;
      }
    case GRANT:{
      t = jj_consume_token(GRANT);
      break;
      }
    case INSERT:{
      t = jj_consume_token(INSERT);
      break;
      }
    case KILL:{
      t = jj_consume_token(KILL);
      break;
      }
    case OPTIMIZE:{
      t = jj_consume_token(OPTIMIZE);
      break;
      }
    case RENAME:{
      t = jj_consume_token(RENAME);
      break;
      }
    case REVOKE:{
      t = jj_consume_token(REVOKE);
      break;
      }
    case SELECT:{
      t = jj_consume_token(SELECT);
      break;
      }
    case SET:{
      t = jj_consume_token(SET);
      break;
      }
    case SHOW:{
      t = jj_consume_token(SHOW);
      break;
      }
    case SYSTEM:{
      t = jj_consume_token(SYSTEM);
      break;
      }
    case TRUNCATE:{
      t = jj_consume_token(TRUNCATE);
      break;
      }
    case UPDATE:{
      t = jj_consume_token(UPDATE);
      break;
      }
    case USE:{
      t = jj_consume_token(USE);
      break;
      }
    case WATCH:{
      t = jj_consume_token(WATCH);
      break;
      }
    case CASE:{
      t = jj_consume_token(CASE);
      break;
      }
    case CLUSTER:{
      t = jj_consume_token(CLUSTER);
      break;
      }
    case DATE:{
      t = jj_consume_token(DATE);
      break;
      }
    case DATABASE:{
      t = jj_consume_token(DATABASE);
      break;
      }
    case DATABASES:{
      t = jj_consume_token(DATABASES);
      break;
      }
    case DICTIONARY:{
      t = jj_consume_token(DICTIONARY);
      break;
      }
    case DICTIONARIES:{
      t = jj_consume_token(DICTIONARIES);
      break;
      }
    case DISTINCT:{
      t = jj_consume_token(DISTINCT);
      break;
      }
    case ELSE:{
      t = jj_consume_token(ELSE);
      break;
      }
    case END:{
      t = jj_consume_token(END);
      break;
      }
    case EXCEPT:{
      t = jj_consume_token(EXCEPT);
      break;
      }
    case FUNCTION:{
      t = jj_consume_token(FUNCTION);
      break;
      }
    case IF:{
      t = jj_consume_token(IF);
      break;
      }
    case INTERVAL:{
      t = jj_consume_token(INTERVAL);
      break;
      }
    case IS:{
      t = jj_consume_token(IS);
      break;
      }
    case LIVE:{
      t = jj_consume_token(LIVE);
      break;
      }
    case MATERIALIZED:{
      t = jj_consume_token(MATERIALIZED);
      break;
      }
    case OUTFILE:{
      t = jj_consume_token(OUTFILE);
      break;
      }
    case POLICY:{
      t = jj_consume_token(POLICY);
      break;
      }
    case PROFILE:{
      t = jj_consume_token(PROFILE);
      break;
      }
    case QUOTA:{
      t = jj_consume_token(QUOTA);
      break;
      }
    case REPLACE:{
      t = jj_consume_token(REPLACE);
      break;
      }
    case ROLE:{
      t = jj_consume_token(ROLE);
      break;
      }
    case ROW:{
      t = jj_consume_token(ROW);
      break;
      }
    case TEMPORARY:{
      t = jj_consume_token(TEMPORARY);
      break;
      }
    case TABLE:{
      t = jj_consume_token(TABLE);
      break;
      }
    case TABLES:{
      t = jj_consume_token(TABLES);
      break;
      }
    case THEN:{
      t = jj_consume_token(THEN);
      break;
      }
    case TIES:{
      t = jj_consume_token(TIES);
      break;
      }
    case TIMESTAMP:{
      t = jj_consume_token(TIMESTAMP);
      break;
      }
    case TOP:{
      t = jj_consume_token(TOP);
      break;
      }
    case TOTALS:{
      t = jj_consume_token(TOTALS);
      break;
      }
    case VALUES:{
      t = jj_consume_token(VALUES);
      break;
      }
    case VIEW:{
      t = jj_consume_token(VIEW);
      break;
      }
    case WHEN:{
      t = jj_consume_token(WHEN);
      break;
      }
    case USER:{
      t = jj_consume_token(USER);
      break;
      }
    case SECOND:{
      t = jj_consume_token(SECOND);
      break;
      }
    case MINUTE:{
      t = jj_consume_token(MINUTE);
      break;
      }
    case HOUR:{
      t = jj_consume_token(HOUR);
      break;
      }
    case DAY:{
      t = jj_consume_token(DAY);
      break;
      }
    case WEEK:{
      t = jj_consume_token(WEEK);
      break;
      }
    case MONTH:{
      t = jj_consume_token(MONTH);
      break;
      }
    case QUARTER:{
      t = jj_consume_token(QUARTER);
      break;
      }
    case YEAR:{
      t = jj_consume_token(YEAR);
      break;
      }
    case INF:{
      t = jj_consume_token(INF);
      break;
      }
    case NAN:{
      t = jj_consume_token(NAN);
      break;
      }
    case NULL:{
      t = jj_consume_token(NULL);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return t;}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_89(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_89()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_90(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_90()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_91(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_91()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_92(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_92()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_93(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_93()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_94(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_94()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_95(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_95()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_96(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_96()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_97(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_97()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_98(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_98()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_99(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_99()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_100(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_100()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_101(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_101()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_102(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_102()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_103(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_103()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_104(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_104()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_105(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_105()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_106(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_106()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_107(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_107()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_108(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_108()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_109(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_109()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_110(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_110()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_111(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_111()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_112(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_112()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_113(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_113()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_114(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_114()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_115(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_115()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_116(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_116()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_117(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_117()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_118(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_118()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_119(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_119()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_120(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_120()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_121(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_121()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_122(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_122()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_123(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_123()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_124(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_124()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_125(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_125()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_126(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_126()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_127(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_127()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_128(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_128()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_129(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_129()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_130(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_130()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) return true;
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_scan_token(ALTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(TABLE)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_scan_token(ON)) return true;
    if (jj_scan_token(CLUSTER)) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(ATTACH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    }
    xsp = jj_scanpos;
    if (jj_3_9()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(REPLACE)) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(CHECK)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(CREATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_11()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    }
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_scan_token(REPLACE)) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) jj_scanpos = xsp;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(DELETE)) return true;
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(88)) jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(DETACH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_14()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    if (jj_scan_token(VIEW)) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) return true;
    }
    return false;
  }

  private boolean jj_3R_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) jj_scanpos = xsp;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_scan_token(DROP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(83)) jj_scanpos = xsp;
    if (jj_scan_token(POLICY)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_3R_44()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) jj_scanpos = xsp;
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(83)) jj_scanpos = xsp;
    if (jj_scan_token(POLICY)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(EXISTS)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_scan_token(EXPLAIN)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_scan_token(GRANT)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(INSERT)) return true;
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) jj_scanpos = xsp;
    if (jj_scan_token(PROFILE)) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) jj_scanpos = xsp;
    if (jj_scan_token(PROFILE)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(FORMAT)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(VALUES)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(150)) jj_scanpos = xsp;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(KILL)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(OPTIMIZE)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(RENAME)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(REVOKE)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) jj_scanpos = xsp;
    if (jj_scan_token(SELECT)) return true;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(DISTINCT)) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_scan_token(SAMPLE)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_scan_token(OFFSET)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(SET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) return true;
    }
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(TOP)) return true;
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_scan_token(DATABASES)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_scan_token(DICTIONARIES)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) jj_scanpos = xsp;
    if (jj_scan_token(TABLES)) return true;
    xsp = jj_scanpos;
    if (jj_3_40()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_39()
 {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_40()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) return true;
    }
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_scan_token(CREATE)) return true;
    if (jj_scan_token(DATABASE)) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_scan_token(DICTIONARY)) return true;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(SYSTEM)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_45()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_scan_token(WITH)) return true;
    if (jj_scan_token(TIES)) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(TRUNCATE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_50()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_51()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(UPDATE)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(USE)) return true;
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    if (jj_scan_token(TEMPORARY)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(WATCH)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    Token xsp;
    if (jj_3_53()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_53()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_64()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = noAndWithinBetween();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == FLOATING_LITERAL;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_3R_52()) return true;
    }
    return false;
  }

  private boolean jj_3R_57()
 {
    Token xsp;
    if (jj_3_54()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    if (jj_scan_token(TABLE)) return true;
    return false;
  }

  private boolean jj_3_59()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) return true;
    }
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    Token xsp;
    if (jj_3_55()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_61()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_scan_token(QUERY)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) {
    jj_scanpos = xsp;
    if (jj_3_79()) return true;
    }
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    Token xsp;
    if (jj_3_66()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_66()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_77()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = noAndWithinBetween();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3_76()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == FLOATING_LITERAL;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    Token xsp;
    if (jj_3_67()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_67()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_72()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) return true;
    }
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    Token xsp;
    if (jj_3_68()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_68()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(EXISTS)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_scan_token(QUERY)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) return true;
    }
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) {
    jj_scanpos = xsp;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3_95()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_93()
 {
    if (jj_scan_token(CASE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_64()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_94()
 {
    if (jj_scan_token(INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) return true;
    }
    return false;
  }

  private boolean jj_3_95()
 {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(WHEN)) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_3R_32()) return true;
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) jj_scanpos = xsp;
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  private boolean jj_3_91()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = noAndWithinBetween();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3_89()) {
    jj_scanpos = xsp;
    if (jj_3_90()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_61()
 {
    Token xsp;
    if (jj_3R_119()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    Token xsp;
    if (jj_3_83()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_83()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    }
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_scan_token(IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) return true;
    }
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    Token xsp;
    if (jj_3_84()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_84()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(71)) jj_scanpos = xsp;
    if (jj_scan_token(IN)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_3R_111()) return true;
    }
    }
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_90()
 {
    if (jj_scan_token(QUERY)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_32()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_3R_32()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_98()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !(tokenIn(1, INF, NAN, NULL) && tokenIn(2, DOT));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_103()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == LPAREN;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_104()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_scan_token(QUERY)) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    Token xsp;
    if (jj_3_101()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_101()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_101()
 {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3_103()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3_104()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(FORMAT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_105()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_99()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_100()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(INTO)) return true;
    if (jj_scan_token(OUTFILE)) return true;
    return false;
  }

  private boolean jj_3_96()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_97()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(WITH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_107()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_105()
 {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_68()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_108()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_102()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3_107()
 {
    if (jj_scan_token(TOTALS)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_3R_70()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_106()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_111()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3_108()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_109()) {
    jj_scanpos = xsp;
    if (jj_3_110()) return true;
    }
    return false;
  }

  private boolean jj_3_109()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_114()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3_116()) {
    jj_scanpos = xsp;
    if (jj_3_117()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_69()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_115()
 {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3_116()
 {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_112()) jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_112()
 {
    if (jj_scan_token(DASH)) return true;
    return false;
  }

  private boolean jj_3_113()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == FLOATING_LITERAL;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  private boolean jj_3R_75()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !(tokenIn(1, INF, NAN, NULL) && tokenIn(2, DOT));
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3_122()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_scan_token(QUERY)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_118()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    if (jj_3_121()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_121()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_121()
 {
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3_122()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3_110()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_123()) {
    jj_scanpos = xsp;
    if (jj_3_124()) {
    jj_scanpos = xsp;
    if (jj_3_125()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_118()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_120()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_119()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3_123()
 {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3_124()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_125()
 {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_3R_167()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_126()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_127()) jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    xsp = jj_scanpos;
    if (jj_3_128()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_127()
 {
    if (jj_3R_51()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_128()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_3R_158()) return true;
    if (jj_scan_token(EQ_SINGLE)) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_3R_102()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_126()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_3R_76()) return true;
    }
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_3R_166()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_3R_154()) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) return true;
    }
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) return true;
    }
    return false;
  }

  private boolean jj_3_129()
 {
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_65()
 {
    if (jj_scan_token(HASH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) return true;
    }
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3_130()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(AT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) return true;
    }
    return false;
  }

  private boolean jj_3R_155()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_171()
 {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(18)) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(21)) {
    jj_scanpos = xsp;
    if (jj_scan_token(22)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public ClickHouseSqlParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;

  /**
   * Constructor with InputStream.
   * @param stream input stream
   */
  public ClickHouseSqlParser(final java.io.InputStream stream) {
	  this(stream, null);
  }

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used
   */
  public ClickHouseSqlParser(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {
   jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
	 token_source = new ClickHouseSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /**
   * Reinitialise
   * @param stream input stream
   */
  public void ReInit(final java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used
   */
  public void ReInit(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {
    jj_input_stream.reInit(stream, encoding, 1, 1);
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public ClickHouseSqlParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ClickHouseSqlParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new ClickHouseSqlParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public ClickHouseSqlParser(final ClickHouseSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final ClickHouseSqlParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
  final Token errortok = token.next;
  final int line = errortok.beginLine;
  final int column = errortok.beginColumn;
  final String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
  return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

}
