/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.events;

import java.util.ListIterator;
import java.util.regex.Pattern;
import ru.yandex.qatools.allure.events.AbstractRemoveAttachmentEvent;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.Step;
import ru.yandex.qatools.allure.utils.AllureResultsUtils;

public class RemoveAttachmentsEvent
extends AbstractRemoveAttachmentEvent {
    public RemoveAttachmentsEvent(String regex) {
        this.setPattern(Pattern.compile(regex));
    }

    @Override
    public void process(Step context) {
        ListIterator iterator = context.getAttachments().listIterator();
        while (iterator.hasNext()) {
            Attachment attachment = (Attachment)iterator.next();
            if (!this.pattern.matcher(attachment.getSource()).matches()) continue;
            AllureResultsUtils.deleteAttachment(attachment);
            iterator.remove();
        }
        for (Step step : context.getSteps()) {
            this.process(step);
        }
    }
}

