/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.junit;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.config.AllureModelUtils;
import ru.yandex.qatools.allure.events.ClearStepStorageEvent;
import ru.yandex.qatools.allure.events.TestCaseCanceledEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFailureEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCasePendingEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.events.TestSuiteStartedEvent;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.utils.AnnotationManager;

public class AllureRunListener
extends RunListener {
    private Allure lifecycle = Allure.LIFECYCLE;
    private final Map<String, String> suites = new HashMap<String, String>();

    public void testSuiteStarted(Description description) {
        String uid = this.generateSuiteUid(description.getClassName());
        TestSuiteStartedEvent event = new TestSuiteStartedEvent(uid, description.getClassName());
        AnnotationManager am = new AnnotationManager(description.getAnnotations());
        am.update(event);
        event.withLabels(AllureModelUtils.createTestFrameworkLabel((String)"JUnit"), new Label[0]);
        this.getLifecycle().fire((TestSuiteEvent)event);
    }

    public void testStarted(Description description) {
        TestCaseStartedEvent event = new TestCaseStartedEvent(this.getSuiteUid(description), description.getMethodName());
        AnnotationManager am = new AnnotationManager(description.getAnnotations());
        am.update(event);
        this.fireClearStepStorage();
        this.getLifecycle().fire(event);
    }

    public void testFailure(Failure failure) {
        if (failure.getDescription().isTest()) {
            this.fireTestCaseFailure(failure.getException());
        } else {
            this.startFakeTestCase(failure.getDescription());
            this.fireTestCaseFailure(failure.getException());
            this.finishFakeTestCase();
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure);
    }

    public void testIgnored(Description description) {
        this.startFakeTestCase(description);
        this.getLifecycle().fire((TestCaseEvent)new TestCasePendingEvent().withMessage(this.getIgnoredMessage(description)));
        this.finishFakeTestCase();
    }

    public void testFinished(Description description) {
        this.getLifecycle().fire(new TestCaseFinishedEvent());
    }

    public void testSuiteFinished(String uid) {
        this.getLifecycle().fire(new TestSuiteFinishedEvent(uid));
    }

    public void testRunFinished(Result result) {
        for (String uid : this.getSuites().values()) {
            this.testSuiteFinished(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSuiteUid(String suiteName) {
        String uid = UUID.randomUUID().toString();
        Map<String, String> map = this.getSuites();
        synchronized (map) {
            this.getSuites().put(suiteName, uid);
        }
        return uid;
    }

    public String getSuiteUid(Description description) {
        String suiteName = description.getClassName();
        if (!this.getSuites().containsKey(suiteName)) {
            Description suiteDescription = Description.createSuiteDescription((Class)description.getTestClass());
            this.testSuiteStarted(suiteDescription);
        }
        return this.getSuites().get(suiteName);
    }

    public String getIgnoredMessage(Description description) {
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        return ignore == null || ignore.value().isEmpty() ? "Test ignored (without reason)!" : ignore.value();
    }

    public void startFakeTestCase(Description description) {
        String uid = this.getSuiteUid(description);
        String name = description.isTest() ? description.getMethodName() : description.getClassName();
        TestCaseStartedEvent event = new TestCaseStartedEvent(uid, name);
        AnnotationManager am = new AnnotationManager(description.getAnnotations());
        am.update(event);
        this.fireClearStepStorage();
        this.getLifecycle().fire(event);
    }

    public void finishFakeTestCase() {
        this.getLifecycle().fire(new TestCaseFinishedEvent());
    }

    public void fireTestCaseFailure(Throwable throwable) {
        if (throwable instanceof AssumptionViolatedException) {
            this.getLifecycle().fire((TestCaseEvent)new TestCaseCanceledEvent().withThrowable(throwable));
        } else {
            this.getLifecycle().fire((TestCaseEvent)new TestCaseFailureEvent().withThrowable(throwable));
        }
    }

    public void fireClearStepStorage() {
        this.getLifecycle().fire(new ClearStepStorageEvent());
    }

    public Allure getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(Allure lifecycle) {
        this.lifecycle = lifecycle;
    }

    public Map<String, String> getSuites() {
        return this.suites;
    }
}

