/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.report;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import ru.yandex.qatools.allure.report.AllureGenerateMojo;

@Mojo(name="bulk", defaultPhase=LifecyclePhase.SITE, inheritByDefault=false)
public class AllureBulkMojo
extends AllureGenerateMojo {
    @Parameter(property="allure.results.inputDirectories")
    protected String inputDirectories;

    @Override
    protected List<String> getInputDirectories() {
        ArrayList<String> results = new ArrayList<String>();
        for (String dir : this.inputDirectories.split(",")) {
            Path path = Paths.get(dir, new String[0]).toAbsolutePath();
            if (this.isDirectoryExists(path)) {
                results.add(path.toString());
                this.getLog().info((CharSequence)("Found results directory " + path));
                continue;
            }
            this.getLog().warn((CharSequence)("Directory " + path + " not found."));
        }
        return results;
    }

    @Override
    protected String getMojoName() {
        return "bulk";
    }
}

