/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.report;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import ru.yandex.qatools.allure.report.AllureResolveMojo;

public abstract class AllureGenerateMojo
extends AllureResolveMojo {
    public static final String MAIN = "main";
    public static final String ALLURE_OLD_PROPERTIES = "allure.properties";
    public static final String ALLURE_NEW_PROPERTIES = "report.properties";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected String buildDirectory;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true)
    protected String reportingOutputDirectory;
    @Parameter(property="allure.results.directory", defaultValue="allure-results/")
    protected String resultsDirectory;
    @Parameter(property="allure.report.directory", defaultValue="${project.reporting.outputDirectory}/allure-maven-plugin")
    protected String reportDirectory;
    @Parameter(readonly=true, defaultValue="ru.yandex.qatools.allure.AllureMain")
    protected String allureMain;
    @Parameter(defaultValue="report.properties")
    protected String propertiesFilePath;
    @Parameter
    protected Map<String, String> properties = new HashMap<String, String>();

    protected String getOutputDirectory() {
        return this.reportDirectory;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        try {
            this.getLog().info((CharSequence)String.format("Generate Allure report (%s) with version %s", this.getMojoName(), this.version));
            ClassLoader loader = this.resolve();
            Class<?> clazz = loader.loadClass(this.allureMain);
            Method main = clazz.getMethod(MAIN, String[].class);
            this.getLog().info((CharSequence)("Generate Allure report to " + this.reportDirectory));
            List<String> inputDirectories = this.getInputDirectories();
            if (inputDirectories.isEmpty()) {
                this.getLog().warn((CharSequence)"Allure report was skipped because there is no results directories found.");
                return;
            }
            this.readPropertiesFile();
            this.readPropertiesFileFromClasspath(ALLURE_OLD_PROPERTIES);
            this.readPropertiesFileFromClasspath(ALLURE_NEW_PROPERTIES);
            this.readPropertiesFromMap();
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.addAll(inputDirectories);
            parameters.add(this.reportDirectory);
            main.invoke(null, new Object[]{parameters.toArray(new String[parameters.size()])});
            this.render(this.getSink(), this.getName(locale));
        }
        catch (Exception e) {
            throw new MavenReportException("Could not generate the report", e);
        }
    }

    protected void readPropertiesFile() throws IOException {
        Path path = Paths.get(this.propertiesFilePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                this.readPropertiesFromStream(is);
            }
        }
    }

    protected void readPropertiesFileFromClasspath(String propertiesFileName) throws IOException, DependencyResolutionRequiredException {
        try (InputStream is = this.createProjectClassLoader().getResourceAsStream(propertiesFileName);){
            this.readPropertiesFromStream(is);
        }
    }

    protected void readPropertiesFromMap() {
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            if (property.getKey() == null || property.getValue() == null) continue;
            System.setProperty(property.getKey(), property.getValue());
        }
    }

    protected void readPropertiesFromStream(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        System.getProperties().load(is);
    }

    protected void render(Sink sink, String title) {
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.lineBreak();
        Path indexHtmlFile = Paths.get(this.reportDirectory, "index.html");
        String relativePath = Paths.get(this.reportingOutputDirectory, new String[0]).relativize(indexHtmlFile).toString();
        sink.rawText(String.format("<meta http-equiv=\"refresh\" content=\"0;url=%s\" />", relativePath));
        sink.link(relativePath);
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected ClassLoader createProjectClassLoader() throws MalformedURLException, DependencyResolutionRequiredException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (Object element : this.project.getTestClasspathElements()) {
            if (element == null || !(element instanceof String)) continue;
            URL url = Paths.get((String)element, new String[0]).toUri().toURL();
            result.add(url);
        }
        return new URLClassLoader(result.toArray(new URL[result.size()]));
    }

    public boolean canGenerateReport() {
        return !this.isAggregate() || this.project.isExecutionRoot();
    }

    protected boolean isAggregate() {
        return false;
    }

    protected boolean isDirectoryExists(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    protected abstract List<String> getInputDirectories();

    protected abstract String getMojoName();
}

