/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.report;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import ru.qatools.clay.aether.Aether;
import ru.qatools.clay.aether.AetherException;
import ru.yandex.qatools.allure.report.AllureBaseMojo;

public abstract class AllureResolveMojo
extends AllureBaseMojo {
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    protected List<RemoteRepository> projectRepositories;
    @Parameter(property="allure.version", defaultValue="RELEASE")
    protected String version;
    @Parameter
    protected List<Dependency> plugins = Collections.emptyList();

    protected Aether createAether() {
        return Aether.aether((RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.repositorySession, this.projectRepositories);
    }

    protected ClassLoader resolve() throws AetherException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        Aether aether = this.createAether();
        for (Dependency plugin : this.plugins) {
            artifacts.addAll(this.collect(aether, plugin));
        }
        artifacts.addAll(this.collect(aether, this.getDefaultBundleDependency()));
        return aether.resolveAll(artifacts.toArray(new Artifact[artifacts.size()])).getAsClassLoader();
    }

    protected List<Artifact> collect(Aether aether, Dependency dependency) throws AetherException {
        List collected = aether.collect(this.convert(dependency));
        this.getLog().debug((CharSequence)("Found " + collected.size() + " dependencies for " + dependency));
        for (Artifact element : collected) {
            this.getLog().debug((CharSequence)String.format("%s:%s:%s", element.getGroupId(), element.getArtifactId(), element.getVersion()));
        }
        return collected;
    }

    protected Artifact convert(Dependency dependency) {
        return new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
    }

    protected Dependency getDefaultBundleDependency() {
        Dependency dependency = new Dependency();
        dependency.setGroupId("ru.yandex.qatools.allure");
        dependency.setArtifactId("allure-bundle");
        dependency.setVersion(this.version);
        return dependency;
    }
}

