/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.report;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import ru.yandex.qatools.allure.report.AllureGenerateMojo;

@Mojo(name="aggregate", defaultPhase=LifecyclePhase.SITE, inheritByDefault=false, aggregator=true)
public class AlureAggregateMojo
extends AllureGenerateMojo {
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;

    @Override
    protected List<String> getInputDirectories() {
        Path relative = Paths.get(this.resultsDirectory, new String[0]);
        if (relative.isAbsolute()) {
            this.getLog().error((CharSequence)"Input directory should be not absolute for aggregate goal.");
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (MavenProject child : this.reactorProjects) {
            Path target = Paths.get(child.getBuild().getDirectory(), new String[0]);
            Path path = target.resolve(relative).toAbsolutePath();
            if (this.isDirectoryExists(path)) {
                result.add(path.toString());
                this.getLog().info((CharSequence)("Found results directory " + path));
                continue;
            }
            this.getLog().warn((CharSequence)("Results directory for module " + child.getName() + " not found."));
        }
        return result;
    }

    @Override
    protected String getMojoName() {
        return "aggregate";
    }

    @Override
    protected boolean isAggregate() {
        return true;
    }
}

