/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.report;

import java.io.File;
import java.net.URLClassLoader;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResult;
import ru.yandex.qatools.allure.report.AllureArtifacts;
import ru.yandex.qatools.allure.report.AllureReportBuilderException;
import ru.yandex.qatools.allure.report.internal.RegexJarEntryFilter;
import ru.yandex.qatools.clay.Aether;
import ru.yandex.qatools.clay.AetherResult;
import ru.yandex.qatools.clay.maven.settings.FluentProfileBuilder;
import ru.yandex.qatools.clay.maven.settings.FluentRepositoryBuilder;
import ru.yandex.qatools.clay.maven.settings.FluentSettingsBuilder;
import ru.yandex.qatools.clay.utils.archive.ArchiveUtil;
import ru.yandex.qatools.clay.utils.archive.JarEntryFilter;

public class AllureReportBuilder {
    public static final String ALLURE_REPORT_GENERATOR_CLASS = "ru.yandex.qatools.allure.data.AllureReportGenerator";
    public static final String ALLURE_REPORT_FACE_FILE_REGEX = "^((?!(META\\-INF|WEB-INF)).)*$";
    public static final String METHOD_NAME = "generate";
    private String version;
    private File outputDirectory;
    private ClassLoader classLoader;
    private Aether aether;

    public AllureReportBuilder(String version, File outputDirectory, Aether aether) throws AllureReportBuilderException {
        this.checkDirectory(outputDirectory);
        this.outputDirectory = outputDirectory;
        this.aether = aether;
        this.version = version;
    }

    public AllureReportBuilder(String version, File outputDirectory) throws AllureReportBuilderException {
        this(version, outputDirectory, Aether.aether((Settings)AllureReportBuilder.mavenSettings()));
    }

    public static Settings mavenSettings() throws AllureReportBuilderException {
        try {
            return FluentSettingsBuilder.loadSettings().withActiveProfile(FluentProfileBuilder.newProfile().withId("allure").withRepository(FluentRepositoryBuilder.newRepository().withUrl("http://repo1.maven.org/maven2"))).build();
        }
        catch (Exception e) {
            throw new AllureReportBuilderException(e);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void processResults(File ... inputDirectories) throws AllureReportBuilderException {
        try {
            this.checkDirectories(inputDirectories);
            DefaultArtifact artifact = AllureArtifacts.getReportDataArtifact(this.version);
            URLClassLoader urlClassLoader = this.aether.resolve((Artifact)artifact).getAsClassLoader(this.getClassLoader());
            Class<?> clazz = urlClassLoader.loadClass(ALLURE_REPORT_GENERATOR_CLASS);
            Object generator = clazz.getConstructor(File[].class).newInstance(new Object[]{inputDirectories});
            clazz.getMethod(METHOD_NAME, File.class).invoke(generator, this.outputDirectory);
        }
        catch (Exception e) {
            throw new AllureReportBuilderException(e);
        }
    }

    public void unpackFace() throws AllureReportBuilderException {
        try {
            DefaultArtifact artifact = AllureArtifacts.getReportFaceArtifact(this.version);
            AetherResult aetherResult = this.aether.resolve((Artifact)artifact);
            File allureReportFace = ((ArtifactResult)aetherResult.get().get(0)).getArtifact().getFile();
            ArchiveUtil.unpackJar((File)allureReportFace, (File)this.outputDirectory, (JarEntryFilter)RegexJarEntryFilter.filterByRegex(ALLURE_REPORT_FACE_FILE_REGEX));
        }
        catch (Exception e) {
            throw new AllureReportBuilderException(e);
        }
    }

    private void checkDirectories(File ... dirs) throws AllureReportBuilderException {
        for (File dir : dirs) {
            this.checkDirectory(dir);
        }
    }

    private void checkDirectory(File dir) throws AllureReportBuilderException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new AllureReportBuilderException("Report directory doesn't exists and can't be created.");
        }
    }
}

