
package ru.yandex.qatools.allure.data;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.Failure;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.Parameter;
import ru.yandex.qatools.allure.model.SeverityLevel;
import ru.yandex.qatools.allure.model.Status;


/**
 * <p>Java class for allure-test-case complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="allure-test-case">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;all>
 *         &lt;element name="uid" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="title" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="time" type="{urn:data.allure.qatools.yandex.ru}time"/>
 *         &lt;element name="summary" type="{urn:data.allure.qatools.yandex.ru}summary"/>
 *         &lt;element name="failure" type="{urn:data.allure.qatools.yandex.ru}failure" minOccurs="0"/>
 *         &lt;element name="description" type="{urn:data.allure.qatools.yandex.ru}description" minOccurs="0"/>
 *         &lt;element name="steps" type="{urn:data.allure.qatools.yandex.ru}allure-steps" minOccurs="0"/>
 *         &lt;element name="attachments" type="{urn:data.allure.qatools.yandex.ru}attachments" minOccurs="0"/>
 *         &lt;element name="severity" type="{urn:data.allure.qatools.yandex.ru}severity-level"/>
 *         &lt;element name="status" type="{urn:data.allure.qatools.yandex.ru}status"/>
 *         &lt;element name="labels" type="{urn:data.allure.qatools.yandex.ru}labels" minOccurs="0"/>
 *         &lt;element name="parameters" type="{urn:data.allure.qatools.yandex.ru}parameters" minOccurs="0"/>
 *       &lt;/all>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "allure-test-case", propOrder = {

})
public class AllureTestCase {

    @XmlElement(required = true)
    protected String uid;
    @XmlElement(required = true)
    protected String name;
    @XmlElement(required = true)
    protected String title;
    @XmlElement(required = true)
    protected Time time;
    @XmlElement(required = true)
    protected Summary summary;
    protected Failure failure;
    protected Description description;
    @XmlElement(required = true)
    protected SeverityLevel severity;
    @XmlElement(required = true)
    protected Status status;
    @XmlElementWrapper(name = "steps")
    @XmlElement(name = "step")
    protected List<AllureStep> steps;
    @XmlElementWrapper(name = "attachments")
    @XmlElement(name = "attachment")
    protected List<Attachment> attachments;
    @XmlElementWrapper(name = "labels")
    @XmlElement(name = "label")
    protected List<Label> labels;
    @XmlElementWrapper(name = "parameters")
    @XmlElement(name = "parameter")
    protected List<Parameter> parameters;

    /**
     * Gets the value of the uid property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUid() {
        return uid;
    }

    /**
     * Sets the value of the uid property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUid(String value) {
        this.uid = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * Gets the value of the time property.
     * 
     * @return
     *     possible object is
     *     {@link Time }
     *     
     */
    public Time getTime() {
        return time;
    }

    /**
     * Sets the value of the time property.
     * 
     * @param value
     *     allowed object is
     *     {@link Time }
     *     
     */
    public void setTime(Time value) {
        this.time = value;
    }

    /**
     * Gets the value of the summary property.
     * 
     * @return
     *     possible object is
     *     {@link Summary }
     *     
     */
    public Summary getSummary() {
        return summary;
    }

    /**
     * Sets the value of the summary property.
     * 
     * @param value
     *     allowed object is
     *     {@link Summary }
     *     
     */
    public void setSummary(Summary value) {
        this.summary = value;
    }

    /**
     * Gets the value of the failure property.
     * 
     * @return
     *     possible object is
     *     {@link Failure }
     *     
     */
    public Failure getFailure() {
        return failure;
    }

    /**
     * Sets the value of the failure property.
     * 
     * @param value
     *     allowed object is
     *     {@link Failure }
     *     
     */
    public void setFailure(Failure value) {
        this.failure = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link Description }
     *     
     */
    public Description getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link Description }
     *     
     */
    public void setDescription(Description value) {
        this.description = value;
    }

    /**
     * Gets the value of the severity property.
     * 
     * @return
     *     possible object is
     *     {@link SeverityLevel }
     *     
     */
    public SeverityLevel getSeverity() {
        return severity;
    }

    /**
     * Sets the value of the severity property.
     * 
     * @param value
     *     allowed object is
     *     {@link SeverityLevel }
     *     
     */
    public void setSeverity(SeverityLevel value) {
        this.severity = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link Status }
     *     
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link Status }
     *     
     */
    public void setStatus(Status value) {
        this.status = value;
    }

    public List<AllureStep> getSteps() {
        if (steps == null) {
            steps = new ArrayList<AllureStep>();
        }
        return steps;
    }

    public void setSteps(List<AllureStep> steps) {
        this.steps = steps;
    }

    public List<Attachment> getAttachments() {
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
        }
        return attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Label> getLabels() {
        if (labels == null) {
            labels = new ArrayList<Label>();
        }
        return labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public List<Parameter> getParameters() {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

}
