/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.clay.maven.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class FluentModelBuilder {
    private final Model model;

    private FluentModelBuilder(Model model) {
        this.model = model;
    }

    public static FluentModelBuilder newModel() {
        return FluentModelBuilder.newPom();
    }

    public static FluentModelBuilder newPom() {
        return new FluentModelBuilder(new Model());
    }

    public static FluentModelBuilder newModel(FileInputStream inputStream) throws IOException, XmlPullParserException {
        return FluentModelBuilder.newPom(inputStream);
    }

    protected static FluentModelBuilder newPom(FileInputStream inputStream) throws IOException, XmlPullParserException {
        return new FluentModelBuilder(new MavenXpp3Reader().read((InputStream)inputStream));
    }

    public FluentModelBuilder marshalTo(File file) throws IOException {
        this.marshalTo(new FileOutputStream(file));
        return this;
    }

    public FluentModelBuilder marshalTo(FileOutputStream outputStream) throws IOException {
        new MavenXpp3Writer().write((OutputStream)outputStream, this.model);
        return this;
    }

    public FluentModelBuilder marshalTo(Writer writer) throws IOException {
        new MavenXpp3Writer().write(writer, this.model);
        return this;
    }

    public Model build() {
        return this.model;
    }

    public FluentModelBuilder withContributor(Contributor contributor) {
        this.model.addContributor(contributor);
        return this;
    }

    public FluentModelBuilder withDeveloper(Developer developer) {
        this.model.addDeveloper(developer);
        return this;
    }

    public FluentModelBuilder withLicense(License license) {
        this.model.addLicense(license);
        return this;
    }

    public FluentModelBuilder withMailingList(MailingList mailingList) {
        this.model.addMailingList(mailingList);
        return this;
    }

    public FluentModelBuilder withProfile(Profile profile) {
        this.model.addProfile(profile);
        return this;
    }

    public FluentModelBuilder withArtifactId(String artifactId) {
        this.model.setArtifactId(artifactId);
        return this;
    }

    public FluentModelBuilder withBuild(Build build) {
        this.model.setBuild(build);
        return this;
    }

    public FluentModelBuilder withCiManagement(CiManagement ciManagement) {
        this.model.setCiManagement(ciManagement);
        return this;
    }

    public FluentModelBuilder withContributors(List<Contributor> contributors) {
        this.model.setContributors(contributors);
        return this;
    }

    public FluentModelBuilder withDescription(String description) {
        this.model.setDescription(description);
        return this;
    }

    public FluentModelBuilder withDevelopers(List<Developer> developers) {
        this.model.setDevelopers(developers);
        return this;
    }

    public FluentModelBuilder withGroupId(String groupId) {
        this.model.setGroupId(groupId);
        return this;
    }

    public FluentModelBuilder withInceptionYear(String inceptionYear) {
        this.model.setInceptionYear(inceptionYear);
        return this;
    }

    public FluentModelBuilder withIssueManagement(IssueManagement issueManagement) {
        this.model.setIssueManagement(issueManagement);
        return this;
    }

    public FluentModelBuilder withLicenses(List<License> licenses) {
        this.model.setLicenses(licenses);
        return this;
    }

    public FluentModelBuilder withMailingLists(List<MailingList> mailingLists) {
        this.model.setMailingLists(mailingLists);
        return this;
    }

    public FluentModelBuilder withModelEncoding(String modelEncoding) {
        this.model.setModelEncoding(modelEncoding);
        return this;
    }

    public FluentModelBuilder withModelVersion(String modelVersion) {
        this.model.setModelVersion(modelVersion);
        return this;
    }

    public FluentModelBuilder withName(String name) {
        this.model.setName(name);
        return this;
    }

    public FluentModelBuilder withOrganization(Organization organization) {
        this.model.setOrganization(organization);
        return this;
    }

    public FluentModelBuilder withPackaging(String packaging) {
        this.model.setPackaging(packaging);
        return this;
    }

    public FluentModelBuilder withParent(Parent parent) {
        this.model.setParent(parent);
        return this;
    }

    public FluentModelBuilder withPrerequisites(Prerequisites prerequisites) {
        this.model.setPrerequisites(prerequisites);
        return this;
    }

    public FluentModelBuilder withProfiles(List<Profile> profiles) {
        this.model.setProfiles(profiles);
        return this;
    }

    public FluentModelBuilder withScm(Scm scm) {
        this.model.setScm(scm);
        return this;
    }

    public FluentModelBuilder withUrl(String url) {
        this.model.setUrl(url);
        return this;
    }

    public FluentModelBuilder withVersion(String version) {
        this.model.setVersion(version);
        return this;
    }

    public FluentModelBuilder withPomFile(File pomFile) {
        this.model.setPomFile(pomFile);
        return this;
    }

    public FluentModelBuilder withDependency(Dependency dependency) {
        this.model.addDependency(dependency);
        return this;
    }

    public FluentModelBuilder withModule(String string) {
        this.model.addModule(string);
        return this;
    }

    public FluentModelBuilder withPluginRepository(Repository repository) {
        this.model.addPluginRepository(repository);
        return this;
    }

    public FluentModelBuilder withProperty(String key, String value) {
        this.model.addProperty(key, value);
        return this;
    }

    public FluentModelBuilder withRepository(Repository repository) {
        this.model.addRepository(repository);
        return this;
    }

    public FluentModelBuilder withDependencies(List<Dependency> dependencies) {
        this.model.setDependencies(dependencies);
        return this;
    }

    public FluentModelBuilder withDependencyManagement(DependencyManagement dependencyManagement) {
        this.model.setDependencyManagement(dependencyManagement);
        return this;
    }

    public FluentModelBuilder withDistributionManagement(DistributionManagement distributionManagement) {
        this.model.setDistributionManagement(distributionManagement);
        return this;
    }

    public FluentModelBuilder withLocation(Object key, InputLocation location) {
        this.model.setLocation(key, location);
        return this;
    }

    public FluentModelBuilder withModules(List<String> modules) {
        this.model.setModules(modules);
        return this;
    }

    public FluentModelBuilder withPluginRepositories(List<Repository> pluginRepositories) {
        this.model.setPluginRepositories(pluginRepositories);
        return this;
    }

    public FluentModelBuilder withProperties(Properties properties) {
        this.model.setProperties(properties);
        return this;
    }

    public FluentModelBuilder withReporting(Reporting reporting) {
        this.model.setReporting(reporting);
        return this;
    }

    public FluentModelBuilder withReports(Object reports) {
        this.model.setReports(reports);
        return this;
    }

    public FluentModelBuilder withRepositories(List<Repository> repositories) {
        this.model.setRepositories(repositories);
        return this;
    }
}

