/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.EmptyFileSet;
import de.flapdoodle.embed.process.store.IDownloader;
import de.flapdoodle.embed.process.store.PostgresArtifactStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedPostgresArtifactStore
extends PostgresArtifactStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedPostgresArtifactStore.class);
    private IDownloadConfig downloadConfig;
    private IDirectory eDir;

    public CachedPostgresArtifactStore(IDownloadConfig downloadConfig, IDirectory eDir, ITempNaming executableNaming, IDownloader downloader) {
        super(downloadConfig, eDir, executableNaming, downloader);
        this.downloadConfig = downloadConfig;
        this.eDir = eDir;
    }

    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
    }

    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        try {
            File dir = this.eDir.asFile();
            FileSet filesSet = this.downloadConfig.getPackageResolver().getFileSet(distribution);
            Path path = Paths.get(dir.getPath(), "pgsql-" + distribution.getVersion().asInDownloadPath(), "bin");
            if (filesSet.entries().stream().allMatch(entry -> Files.exists(path, new LinkOption[0]))) {
                ImmutableExtractedFileSet.Builder extracted = ImmutableExtractedFileSet.builder((File)dir).baseDirIsGenerated(false);
                FileUtils.iterateFiles((File)dir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE).forEachRemaining(file -> {
                    FileType type = FileType.Library;
                    if (filesSet.entries().stream().anyMatch(entry -> entry.matchingPattern().matcher(file.getPath()).matches())) {
                        type = FileType.Executable;
                    }
                    extracted.file(type, file);
                });
                return extracted.build();
            }
            return super.extractFileSet(distribution);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract file set", (Throwable)e);
            return new EmptyFileSet();
        }
    }
}

