/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.matchers.nio;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class DirectoryContains
extends TypeSafeMatcher<Path> {
    private String fileName;

    public DirectoryContains(String fileName) {
        this.fileName = fileName;
    }

    protected boolean matchesSafely(Path directory) {
        return Files.exists(directory.resolve(this.fileName), new LinkOption[0]);
    }

    public void describeTo(Description description) {
        description.appendText("contains file ").appendValue((Object)this.fileName);
    }

    protected void describeMismatchSafely(Path item, Description description) {
        description.appendText("not contains file ").appendValue((Object)this.fileName);
    }
}

