/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.matchers.nio;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FilesCount
extends TypeSafeMatcher<Path> {
    public static final String DEFAULT_GLOB = "*";
    private final String glob;
    private final int expectedCount;
    private int count = 0;

    public FilesCount(int expectedCount) {
        this(expectedCount, DEFAULT_GLOB);
    }

    public FilesCount(int expectedCount, String glob) {
        this.expectedCount = expectedCount;
        this.glob = glob;
    }

    protected boolean matchesSafely(Path item) {
        this.count = 0;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(item, this.glob);){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                ++this.count;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.expectedCount == this.count;
    }

    public void describeTo(Description description) {
        description.appendText("directory contains ").appendValue((Object)this.expectedCount).appendText(" files");
        if (!DEFAULT_GLOB.equals(this.glob)) {
            description.appendText(" with glob ").appendValue((Object)this.glob);
        }
    }

    protected void describeMismatchSafely(Path item, Description mismatchDescription) {
        mismatchDescription.appendText("directory contains ").appendValue((Object)this.count).appendText(" files");
        if (!DEFAULT_GLOB.equals(this.glob)) {
            mismatchDescription.appendText(" with glob ").appendValue((Object)this.glob);
        }
    }
}

