/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.matchers.nio;

import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import ru.yandex.qatools.matchers.nio.DirectoryContains;
import ru.yandex.qatools.matchers.nio.Exists;
import ru.yandex.qatools.matchers.nio.FilesCount;
import ru.yandex.qatools.matchers.nio.IsDirectory;

public final class PathMatchers {
    PathMatchers() {
    }

    @Factory
    public static Matcher<Path> contains(String fileName) {
        return new DirectoryContains(fileName);
    }

    @Factory
    public static Matcher<Path> isDirectory() {
        return new IsDirectory();
    }

    @Factory
    public static Matcher<Path> exists(LinkOption ... options) {
        return new Exists(options);
    }

    @Factory
    public static Matcher<Path> hasFilesCount(int expectedCount) {
        return new FilesCount(expectedCount);
    }

    @Factory
    public static Matcher<Path> hasFilesCount(int expectedCount, String glob) {
        return new FilesCount(expectedCount, glob);
    }
}

