/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.properties;

import java.lang.reflect.Field;
import java.util.Properties;
import ru.yandex.qatools.properties.annotations.With;
import ru.yandex.qatools.properties.decorators.DefaultFieldDecorator;
import ru.yandex.qatools.properties.decorators.FieldDecorator;
import ru.yandex.qatools.properties.exeptions.PropertyLoaderException;
import ru.yandex.qatools.properties.providers.DefaultPropertyProvider;
import ru.yandex.qatools.properties.providers.PropertyProvider;

public final class PropertyLoader {
    private PropertyLoader() {
    }

    public static <T> void populate(T bean) {
        PropertyLoader.populate(bean, new Properties());
    }

    public static <T> void populate(T bean, Properties properties) {
        PropertyProvider provider = PropertyLoader.instantiatePropertyProvider(bean);
        Properties completed = provider.provide(bean, properties);
        PropertyLoader.populate(bean, new DefaultFieldDecorator(completed));
    }

    public static <T> void populate(T bean, FieldDecorator decorator) {
        for (Class<?> clazz = bean.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            PropertyLoader.initFields(decorator, bean, clazz);
        }
    }

    private static void initFields(FieldDecorator decorator, Object bean, Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object value = decorator.decorate(field);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(bean, value);
            }
            catch (IllegalAccessException e) {
                throw new PropertyLoaderException(String.format("Can not set bean <%s> field <%s> value", bean, field), e);
            }
        }
    }

    private static <T> PropertyProvider instantiatePropertyProvider(T bean) {
        Class<?> clazz = bean.getClass();
        if (clazz.isAnnotationPresent(With.class)) {
            try {
                return clazz.getAnnotation(With.class).value().newInstance();
            }
            catch (InstantiationException e) {
                throw new PropertyLoaderException("Can't create instance property provider in class " + bean.getClass().getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyLoaderException("Can't load property provider in class " + bean.getClass().getName(), e);
            }
        }
        return new DefaultPropertyProvider();
    }
}

