/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.properties.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Properties;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties readProperties(File file) {
        try {
            return PropertiesUtils.readProperties(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return new Properties();
        }
    }

    public static Properties readProperties(InputStream inputStream) {
        if (inputStream == null) {
            return new Properties();
        }
        return PropertiesUtils.readProperties(new InputStreamReader(inputStream, Charset.defaultCharset()));
    }

    public static Properties readProperties(Reader reader) {
        Properties result = new Properties();
        try {
            result.load(reader);
            return result;
        }
        catch (IOException e) {
            return result;
        }
    }
}

