/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.brave;

import brave.Request;
import brave.Span;
import brave.Tracing;
import brave.propagation.TraceContext;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class B3SingleFormatSpanConverter {
    @Nonnull
    private final Tracing tracing;

    B3SingleFormatSpanConverter(@Nonnull Tracing tracing) {
        this.tracing = Objects.requireNonNull(tracing);
    }

    @Nonnull
    Optional<TraceContext> deserializeTraceContext(@Nullable String traceInfo) {
        TraceContext.Extractor extractor = this.tracing.propagation().extractor((rec$, x$0) -> ((TraceInfo)((Object)((Object)rec$))).get(x$0));
        return TraceInfo.fromString(traceInfo).map(tr -> extractor.extract((Object)tr).context());
    }

    @Nonnull
    String serializeTraceContext(@Nonnull TraceContext traceContext) {
        Objects.requireNonNull(traceContext);
        TraceContext.Injector injector = this.tracing.propagation().injector((rec$, x$0, x$1) -> ((TraceInfo)((Object)((Object)rec$))).put(x$0, x$1));
        TraceInfo traceInfo = new TraceInfo();
        injector.inject(traceContext, (Object)traceInfo);
        return traceInfo.asString();
    }

    private static final class TraceInfo
    extends Request {
        private final Map<String, String> data = new LinkedHashMap<String, String>();

        private TraceInfo() {
        }

        private boolean isEmpty() {
            return this.data.isEmpty();
        }

        private void put(String key, String value) {
            this.data.put(key, value);
        }

        private String get(String key) {
            return this.data.get(key);
        }

        static Optional<TraceInfo> fromString(String val) {
            if (val == null || val.isEmpty()) {
                return Optional.empty();
            }
            TraceInfo traceInfo = new TraceInfo();
            String[] split = val.split("\n");
            Arrays.asList(split).forEach(keyvalPair -> {
                String[] kv = keyvalPair.split("=", 2);
                if (kv.length != 2) {
                    return;
                }
                traceInfo.put(kv[0], kv[1]);
            });
            if (traceInfo.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(traceInfo);
        }

        String asString() {
            StringJoiner stringJoiner = new StringJoiner("\n");
            this.data.forEach((key, val) -> stringJoiner.add(key + "=" + val));
            return stringJoiner.toString();
        }

        public Span.Kind spanKind() {
            return Span.Kind.PRODUCER;
        }

        public Object unwrap() {
            return this;
        }
    }
}

