/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.api.EnqueueResult;
import ru.yoomoney.tech.dbqueue.api.QueueProducer;
import ru.yoomoney.tech.dbqueue.api.TaskPayloadTransformer;
import ru.yoomoney.tech.dbqueue.brave.B3SingleFormatSpanConverter;
import ru.yoomoney.tech.dbqueue.settings.QueueId;

public class TracingQueueProducer<PayloadT>
implements QueueProducer<PayloadT> {
    private static final Logger log = LoggerFactory.getLogger(TracingQueueProducer.class);
    @Nonnull
    private final QueueProducer<PayloadT> queueProducer;
    @Nonnull
    private final Tracing tracing;
    @Nonnull
    private final B3SingleFormatSpanConverter spanConverter;
    @Nonnull
    private final QueueId queueId;
    @Nonnull
    private final String traceField;

    public TracingQueueProducer(@Nonnull QueueProducer<PayloadT> queueProducer, @Nonnull QueueId queueId, @Nonnull Tracing tracing, @Nonnull String traceField) {
        this.queueProducer = Objects.requireNonNull(queueProducer, "enqueuer");
        this.tracing = Objects.requireNonNull(tracing, "tracing");
        this.queueId = Objects.requireNonNull(queueId, "queueId");
        this.traceField = Objects.requireNonNull(traceField, "traceField");
        this.spanConverter = new B3SingleFormatSpanConverter(tracing);
    }

    private EnqueueResult enqueueInternal(@Nonnull EnqueueParams<PayloadT> enqueueParams, boolean isProduceNewTrace) {
        Span span;
        Span span2 = span = isProduceNewTrace ? this.tracing.tracer().newTrace() : this.tracing.tracer().nextSpan();
        if (isProduceNewTrace) {
            log.info("enqueing task in new trace: newTraceId={}", (Object)span.context().traceIdString());
        }
        span.name("qsend " + this.queueId.asString()).tag("queue.name", this.queueId.asString()).tag("queue.operation", "send").kind(Span.Kind.PRODUCER);
        try {
            EnqueueResult enqueueResult;
            block10: {
                Tracer.SpanInScope spanInScope = this.tracing.tracer().withSpanInScope(span.start());
                try {
                    enqueueParams.withExtData(this.traceField, this.spanConverter.serializeTraceContext(span.context()));
                    enqueueResult = this.queueProducer.enqueue(enqueueParams);
                    if (spanInScope == null) break block10;
                }
                catch (Throwable throwable) {
                    if (spanInScope != null) {
                        try {
                            spanInScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                spanInScope.close();
            }
            return enqueueResult;
        }
        finally {
            span.finish();
        }
    }

    public EnqueueResult enqueue(@Nonnull EnqueueParams<PayloadT> enqueueParams) {
        return this.enqueueInternal(enqueueParams, false);
    }

    @Nonnull
    public TaskPayloadTransformer<PayloadT> getPayloadTransformer() {
        return this.queueProducer.getPayloadTransformer();
    }

    public EnqueueResult enqueueInNewTrace(@Nonnull EnqueueParams<PayloadT> enqueueParams) {
        return this.enqueueInternal(enqueueParams, true);
    }
}

