/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.brave;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.api.TaskExecutionResult;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.brave.B3SingleFormatSpanConverter;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class TracingTaskLifecycleListener
implements TaskLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(TracingTaskLifecycleListener.class);
    private static final ThreadLocal<SpanAndScope> threadLocalSpan = new ThreadLocal();
    @Nonnull
    private final Tracing tracing;
    @Nonnull
    private final B3SingleFormatSpanConverter spanConverter;
    private final String traceField;

    public TracingTaskLifecycleListener(@Nonnull Tracing tracing, String traceField) {
        this.tracing = tracing;
        this.spanConverter = new B3SingleFormatSpanConverter(tracing);
        this.traceField = traceField;
    }

    public void picked(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, long pickTaskTime) {
    }

    public void started(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
        String queueName = location.getQueueId().asString();
        String traceInfo = (String)taskRecord.getExtData().get(this.traceField);
        Span taskSpan = this.spanConverter.deserializeTraceContext(traceInfo).map(ctx -> this.tracing.tracer().nextSpan(TraceContextOrSamplingFlags.create((TraceContext)ctx))).orElseGet(() -> {
            log.info("unknown trace context, creating new");
            return this.tracing.tracer().newTrace();
        });
        taskSpan.name("qreceive " + queueName).tag("queue.name", queueName).tag("queue.operation", "receive").kind(Span.Kind.CONSUMER);
        threadLocalSpan.set(new SpanAndScope(taskSpan, this.tracing.tracer().withSpanInScope(taskSpan.start())));
    }

    public void executed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nonnull TaskExecutionResult executionResult, long processTaskTime) {
    }

    public void finished(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
        SpanAndScope spanAndScope = threadLocalSpan.get();
        threadLocalSpan.remove();
        spanAndScope.spanInScope.close();
        spanAndScope.span.finish();
    }

    public void crashed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nullable Exception exc) {
        TracingTaskLifecycleListener.threadLocalSpan.get().span.error((Throwable)exc);
    }

    private static final class SpanAndScope {
        @Nonnull
        final Span span;
        @Nonnull
        final Tracer.SpanInScope spanInScope;

        SpanAndScope(@Nonnull Span span, @Nonnull Tracer.SpanInScope spanInScope) {
            this.span = Objects.requireNonNull(span);
            this.spanInScope = Objects.requireNonNull(spanInScope);
        }
    }
}

