/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueueDao;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class Oracle11QueueDao
implements QueueDao {
    private final Map<QueueLocation, String> enqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> deleteSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<QueueLocation, String> reenqueueSqlCache = new ConcurrentHashMap<QueueLocation, String>();
    private final Map<String, String> nextSequenceSqlCache = new ConcurrentHashMap<String, String>();
    @Nonnull
    private final NamedParameterJdbcTemplate jdbcTemplate;
    @Nonnull
    private final QueueTableSchema queueTableSchema;

    public Oracle11QueueDao(@Nonnull JdbcOperations jdbcTemplate, @Nonnull QueueTableSchema queueTableSchema) {
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema);
        this.jdbcTemplate = new NamedParameterJdbcTemplate(Objects.requireNonNull(jdbcTemplate));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE", "SQL_INJECTION_SPRING_JDBC"})
    public long enqueue(@Nonnull QueueLocation location, @Nonnull EnqueueParams<String> enqueueParams) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(enqueueParams);
        String idSequence = (String)location.getIdSequence().orElseThrow(() -> new IllegalStateException("id sequence must be specified for oracle 11g database"));
        Long generatedId = Objects.requireNonNull((Long)this.jdbcTemplate.getJdbcTemplate().queryForObject(this.nextSequenceSqlCache.computeIfAbsent(idSequence, this::createNextSequenceSql), Long.class));
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("queueName", (Object)location.getQueueId().asString()).addValue("payload", enqueueParams.getPayload()).addValue("executionDelay", (Object)enqueueParams.getExecutionDelay().getSeconds()).addValue("id", (Object)generatedId);
        this.queueTableSchema.getExtFields().forEach(paramName -> params.addValue(paramName, null));
        enqueueParams.getExtData().forEach((arg_0, arg_1) -> ((MapSqlParameterSource)params).addValue(arg_0, arg_1));
        this.jdbcTemplate.update(this.enqueueSqlCache.computeIfAbsent(location, this::createEnqueueSql), (SqlParameterSource)params);
        return generatedId;
    }

    public boolean deleteTask(@Nonnull QueueLocation location, long taskId) {
        Objects.requireNonNull(location);
        int updatedRows = this.jdbcTemplate.update(this.deleteSqlCache.computeIfAbsent(location, this::createDeleteSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()));
        return updatedRows != 0;
    }

    public boolean reenqueue(@Nonnull QueueLocation location, long taskId, @Nonnull Duration executionDelay) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(executionDelay);
        int updatedRows = this.jdbcTemplate.update(this.reenqueueSqlCache.computeIfAbsent(location, this::createReenqueueSql), (SqlParameterSource)new MapSqlParameterSource().addValue("id", (Object)taskId).addValue("queueName", (Object)location.getQueueId().asString()).addValue("executionDelay", (Object)executionDelay.getSeconds()));
        return updatedRows != 0;
    }

    private String createDeleteSql(@Nonnull QueueLocation location) {
        return "DELETE FROM " + location.getTableName() + " WHERE " + this.queueTableSchema.getQueueNameField() + " = :queueName AND " + this.queueTableSchema.getIdField() + " = :id";
    }

    private String createEnqueueSql(@Nonnull QueueLocation location) {
        return "INSERT INTO " + location.getTableName() + "(" + this.queueTableSchema.getIdField() + "," + this.queueTableSchema.getQueueNameField() + "," + this.queueTableSchema.getPayloadField() + "," + this.queueTableSchema.getNextProcessAtField() + "," + this.queueTableSchema.getReenqueueAttemptField() + "," + this.queueTableSchema.getTotalAttemptField() + (this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().collect(Collectors.joining(", ", ", ", ""))) + ") VALUES (:id, :queueName, :payload, CURRENT_TIMESTAMP + :executionDelay * INTERVAL '1' SECOND, 0, 0" + (this.queueTableSchema.getExtFields().isEmpty() ? "" : this.queueTableSchema.getExtFields().stream().map(field -> ":" + field).collect(Collectors.joining(", ", ", ", ""))) + ")";
    }

    private String createReenqueueSql(@Nonnull QueueLocation location) {
        return "UPDATE " + location.getTableName() + " SET " + this.queueTableSchema.getNextProcessAtField() + " = CURRENT_TIMESTAMP + :executionDelay * INTERVAL '1' SECOND, " + this.queueTableSchema.getAttemptField() + " = 0, " + this.queueTableSchema.getReenqueueAttemptField() + " = " + this.queueTableSchema.getReenqueueAttemptField() + " + 1 WHERE " + this.queueTableSchema.getIdField() + " = :id AND " + this.queueTableSchema.getQueueNameField() + " = :queueName";
    }

    private String createNextSequenceSql(String idSequence) {
        return "SELECT " + idSequence + ".nextval FROM dual";
    }
}

