/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.JdbcOperations;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.settings.FailRetryType;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

@SuppressFBWarnings(value={"UCPM_USE_CHARACTER_PARAMETERIZED_METHOD", "ISB_INEFFICIENT_STRING_BUFFERING"})
public class Oracle11QueuePickTaskDao
implements QueuePickTaskDao {
    @Nonnull
    private final JdbcOperations jdbcTemplate;
    @Nonnull
    private final QueueTableSchema queueTableSchema;
    private PickTaskCallableStatement pickTaskStatement;
    private String pickTaskSql;

    public Oracle11QueuePickTaskDao(@Nonnull JdbcOperations jdbcTemplate, @Nonnull QueueTableSchema queueTableSchema, @Nonnull QueueLocation queueLocation, @Nonnull FailureSettings failureSettings) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate);
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema);
        this.pickTaskStatement = new PickTaskCallableStatement(queueTableSchema, queueLocation, failureSettings);
        this.pickTaskSql = this.createPickTaskSql(queueLocation, failureSettings);
        failureSettings.registerObserver((oldValue, newValue) -> {
            this.pickTaskSql = this.createPickTaskSql(queueLocation, (FailureSettings)newValue);
            this.pickTaskStatement = new PickTaskCallableStatement(queueTableSchema, queueLocation, (FailureSettings)newValue);
        });
    }

    @Nullable
    @SuppressFBWarnings(value={"SQL_INJECTION_SPRING_JDBC"})
    public TaskRecord pickTask() {
        return (TaskRecord)this.jdbcTemplate.execute(this.pickTaskSql, (CallableStatementCallback)this.pickTaskStatement);
    }

    @Nonnull
    private String getNextProcessTimeSql(@Nonnull FailRetryType failRetryType) {
        Objects.requireNonNull(failRetryType);
        switch (failRetryType) {
            case GEOMETRIC_BACKOFF: {
                return "CURRENT_TIMESTAMP + power(2, rattempt) * ? * (INTERVAL '1' SECOND)";
            }
            case ARITHMETIC_BACKOFF: {
                return "CURRENT_TIMESTAMP + (1 + (rattempt * 2)) * ? * (INTERVAL '1' SECOND)";
            }
            case LINEAR_BACKOFF: {
                return "CURRENT_TIMESTAMP + ? * (INTERVAL '1' SECOND)";
            }
        }
        throw new IllegalStateException("unknown retry type: " + failRetryType);
    }

    private String createPickTaskSql(QueueLocation queueLocation, FailureSettings failureSettings) {
        StringBuilder declaration = new StringBuilder("DECLARE\n rid " + queueLocation.getTableName() + "." + this.queueTableSchema.getIdField() + "%TYPE;\n rpayload " + queueLocation.getTableName() + "." + this.queueTableSchema.getPayloadField() + "%TYPE;\n rattempt " + queueLocation.getTableName() + "." + this.queueTableSchema.getAttemptField() + "%TYPE;\n rreenqueue_attempt " + queueLocation.getTableName() + "." + this.queueTableSchema.getReenqueueAttemptField() + "%TYPE;\n rtotal_attempt " + queueLocation.getTableName() + "." + this.queueTableSchema.getTotalAttemptField() + "%TYPE;\n rcreated_at " + queueLocation.getTableName() + "." + this.queueTableSchema.getCreatedAtField() + "%TYPE;\n rnext_process_at " + queueLocation.getTableName() + "." + this.queueTableSchema.getNextProcessAtField() + "%TYPE;\n");
        this.queueTableSchema.getExtFields().forEach(field -> declaration.append("r").append((String)field).append(" ").append(queueLocation.getTableName()).append(".").append((String)field).append("%TYPE;\n"));
        StringBuilder cursorSelect = new StringBuilder(" CURSOR c IS SELECT " + this.queueTableSchema.getIdField() + ", " + this.queueTableSchema.getPayloadField() + ", " + this.queueTableSchema.getAttemptField() + ", " + this.queueTableSchema.getReenqueueAttemptField() + ", " + this.queueTableSchema.getTotalAttemptField() + ", " + this.queueTableSchema.getCreatedAtField() + ", ");
        this.queueTableSchema.getExtFields().forEach(field -> cursorSelect.append((String)field).append(", "));
        cursorSelect.append(this.queueTableSchema.getNextProcessAtField()).append(" ");
        StringBuilder fetchParams = new StringBuilder("rid, rpayload, rattempt, rreenqueue_attempt, rtotal_attempt, rcreated_at, ");
        this.queueTableSchema.getExtFields().forEach(field -> fetchParams.append("r").append((String)field).append(", "));
        fetchParams.append("rnext_process_at;\n");
        String updateSql = "IF (c%NOTFOUND) THEN \n rid := 0;\n  END IF\n; CLOSE c;\n IF (rid > 0) THEN \n rnext_process_at := " + this.getNextProcessTimeSql(failureSettings.getRetryType()) + ";\n rattempt := rattempt + 1;\n rtotal_attempt := rtotal_attempt + 1;\n   UPDATE " + queueLocation.getTableName() + " SET " + this.queueTableSchema.getNextProcessAtField() + " = rnext_process_at, " + this.queueTableSchema.getAttemptField() + " = rattempt,  " + this.queueTableSchema.getTotalAttemptField() + " = rtotal_attempt WHERE " + this.queueTableSchema.getIdField() + " = rid; \n END IF;";
        StringBuilder returnParams = new StringBuilder("\n ? := rid; \n ? := rpayload; \n ? := rattempt; \n ? := rreenqueue_attempt; \n ? := rtotal_attempt; \n ? := rcreated_at; \n ? := rnext_process_at; ");
        this.queueTableSchema.getExtFields().forEach(field -> returnParams.append("\n ? := r").append((String)field).append("; "));
        returnParams.append("\n END; ");
        String fetchCursor = " FROM " + queueLocation.getTableName() + "  WHERE " + this.queueTableSchema.getQueueNameField() + " = ? AND " + this.queueTableSchema.getNextProcessAtField() + " <= CURRENT_TIMESTAMP FOR UPDATE SKIP LOCKED; BEGIN \n OPEN c; \n FETCH c INTO ";
        return declaration.toString() + cursorSelect + fetchCursor + fetchParams + updateSql + returnParams;
    }

    private static class PickTaskCallableStatement
    implements CallableStatementCallback<TaskRecord> {
        private final QueueLocation queueLocation;
        private final FailureSettings failureSettings;
        private final QueueTableSchema queueTableSchema;

        public PickTaskCallableStatement(QueueTableSchema queueTableSchema, QueueLocation queueLocation, FailureSettings failureSettings) {
            this.queueLocation = queueLocation;
            this.failureSettings = failureSettings;
            this.queueTableSchema = queueTableSchema;
        }

        public TaskRecord doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            int inputIndex = 1;
            cs.setString(inputIndex++, this.queueLocation.getQueueId().asString());
            cs.setLong(inputIndex++, this.failureSettings.getRetryInterval().getSeconds());
            cs.registerOutParameter(inputIndex++, -5);
            cs.registerOutParameter(inputIndex++, 2005);
            cs.registerOutParameter(inputIndex++, -5);
            cs.registerOutParameter(inputIndex++, -5);
            cs.registerOutParameter(inputIndex++, -5);
            cs.registerOutParameter(inputIndex++, 93);
            cs.registerOutParameter(inputIndex++, 93);
            for (String ignored : this.queueTableSchema.getExtFields()) {
                cs.registerOutParameter(inputIndex++, 12);
            }
            cs.execute();
            int resultIndex = 3;
            long id = cs.getLong(resultIndex++);
            if (id == 0L) {
                return null;
            }
            TaskRecord.Builder builder = TaskRecord.builder().withId(id).withPayload(cs.getString(resultIndex++)).withAttemptsCount(cs.getLong(resultIndex++)).withReenqueueAttemptsCount(cs.getLong(resultIndex++)).withTotalAttemptsCount(cs.getLong(resultIndex++)).withCreatedAt(this.getZonedDateTime(cs.getTimestamp(resultIndex++))).withNextProcessAt(this.getZonedDateTime(cs.getTimestamp(resultIndex++)));
            HashMap<String, String> extData = new HashMap<String, String>(this.queueTableSchema.getExtFields().size());
            for (String field : this.queueTableSchema.getExtFields()) {
                extData.put(field, cs.getString(resultIndex++));
            }
            return builder.withExtData(extData).build();
        }

        private ZonedDateTime getZonedDateTime(Timestamp timestamp) {
            return ZonedDateTime.ofInstant(timestamp.toInstant(), ZoneId.systemDefault());
        }
    }
}

