/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.spring.dao;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.transaction.support.TransactionOperations;
import ru.yoomoney.tech.dbqueue.config.DatabaseAccessLayer;
import ru.yoomoney.tech.dbqueue.config.DatabaseDialect;
import ru.yoomoney.tech.dbqueue.config.QueueTableSchema;
import ru.yoomoney.tech.dbqueue.dao.QueueDao;
import ru.yoomoney.tech.dbqueue.dao.QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.settings.FailureSettings;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;
import ru.yoomoney.tech.dbqueue.spring.dao.H2QueueDao;
import ru.yoomoney.tech.dbqueue.spring.dao.H2QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.spring.dao.MssqlQueueDao;
import ru.yoomoney.tech.dbqueue.spring.dao.MssqlQueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.spring.dao.Oracle11QueueDao;
import ru.yoomoney.tech.dbqueue.spring.dao.Oracle11QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.spring.dao.PostgresQueueDao;
import ru.yoomoney.tech.dbqueue.spring.dao.PostgresQueuePickTaskDao;

public class SpringDatabaseAccessLayer
implements DatabaseAccessLayer {
    @Nonnull
    private final JdbcOperations jdbcOperations;
    @Nonnull
    private final TransactionOperations transactionOperations;
    @Nonnull
    private final DatabaseDialect databaseDialect;
    @Nonnull
    private final QueueTableSchema queueTableSchema;
    @Nonnull
    private final QueueDao queueDao;

    public SpringDatabaseAccessLayer(@Nonnull DatabaseDialect databaseDialect, @Nonnull QueueTableSchema queueTableSchema, @Nonnull JdbcOperations jdbcOperations, @Nonnull TransactionOperations transactionOperations) {
        this.databaseDialect = Objects.requireNonNull(databaseDialect);
        this.queueTableSchema = Objects.requireNonNull(queueTableSchema);
        this.jdbcOperations = Objects.requireNonNull(jdbcOperations);
        this.transactionOperations = Objects.requireNonNull(transactionOperations);
        this.queueDao = this.createQueueDao(databaseDialect, queueTableSchema, jdbcOperations);
    }

    @Nonnull
    public QueueDao getQueueDao() {
        return this.queueDao;
    }

    private QueueDao createQueueDao(@Nonnull DatabaseDialect databaseDialect, @Nonnull QueueTableSchema queueTableSchema, @Nonnull JdbcOperations jdbcOperations) {
        Objects.requireNonNull(databaseDialect);
        Objects.requireNonNull(jdbcOperations);
        Objects.requireNonNull(queueTableSchema);
        switch (databaseDialect) {
            case POSTGRESQL: {
                return new PostgresQueueDao(jdbcOperations, queueTableSchema);
            }
            case MSSQL: {
                return new MssqlQueueDao(jdbcOperations, queueTableSchema);
            }
            case ORACLE_11G: {
                return new Oracle11QueueDao(jdbcOperations, queueTableSchema);
            }
            case H2: {
                return new H2QueueDao(jdbcOperations, queueTableSchema);
            }
        }
        throw new IllegalArgumentException("unsupported database kind: " + databaseDialect);
    }

    @Nonnull
    public QueuePickTaskDao createQueuePickTaskDao(@Nonnull QueueLocation queueLocation, @Nonnull FailureSettings failureSettings) {
        Objects.requireNonNull(this.databaseDialect);
        Objects.requireNonNull(this.queueTableSchema);
        Objects.requireNonNull(queueLocation);
        Objects.requireNonNull(failureSettings);
        switch (this.databaseDialect) {
            case POSTGRESQL: {
                return new PostgresQueuePickTaskDao(this.jdbcOperations, this.queueTableSchema, queueLocation, failureSettings);
            }
            case MSSQL: {
                return new MssqlQueuePickTaskDao(this.jdbcOperations, this.queueTableSchema, queueLocation, failureSettings);
            }
            case ORACLE_11G: {
                return new Oracle11QueuePickTaskDao(this.jdbcOperations, this.queueTableSchema, queueLocation, failureSettings);
            }
            case H2: {
                return new H2QueuePickTaskDao(this.jdbcOperations, this.queueTableSchema, queueLocation, failureSettings);
            }
        }
        throw new IllegalArgumentException("unsupported database kind: " + this.databaseDialect);
    }

    @Nonnull
    public DatabaseDialect getDatabaseDialect() {
        return this.databaseDialect;
    }

    @Nonnull
    public QueueTableSchema getQueueTableSchema() {
        return this.queueTableSchema;
    }

    public <T> T transact(@Nonnull Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return (T)this.transactionOperations.execute(status -> supplier.get());
    }

    public void transact(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.transact(() -> {
            runnable.run();
            return null;
        });
    }

    @Nonnull
    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    @Nonnull
    public TransactionOperations getTransactionOperations() {
        return this.transactionOperations;
    }
}

