/*
 * Decompiled with CFR 0.152.
 */
package ru.ztrap.rxslideup;

import com.mancj.slideup.SlideUp;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import ru.ztrap.rxslideup.SlideUpObservable;
import ru.ztrap.rxslideup.ThreadUtils;
import ru.ztrap.rxslideup.events.SlideUpEvent;

final class EventsObservable
extends Observable<SlideUpEvent> {
    private final SlideUp mSlideUp;

    EventsObservable(SlideUp slideUp) {
        this.mSlideUp = slideUp;
    }

    protected void subscribeActual(Observer<? super SlideUpEvent> observer) {
        if (ThreadUtils.checkNotMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.mSlideUp, observer);
        observer.onSubscribe((Disposable)listener);
        this.mSlideUp.addSlideListener((SlideUp.Listener)listener);
    }

    final class Listener
    extends SlideUpObservable<SlideUpEvent>
    implements SlideUp.Listener.Events {
        private int mVisibility;
        private float mPercent;

        Listener(SlideUp slideUp, Observer<? super SlideUpEvent> observer) {
            super(slideUp, observer);
            this.mVisibility = this.mSlideUp.getSliderView().getVisibility();
            this.mPercent = this.mSlideUp.isVisible() ? 0.0f : 100.0f;
        }

        protected void onDispose() {
            this.mSlideUp.removeSlideListener((SlideUp.Listener)this);
        }

        public void onSlide(float percent) {
            this.mPercent = percent;
            if (!this.isDisposed()) {
                this.mObserver.onNext((Object)new SlideUpEvent(this.mSlideUp, this.mPercent, this.mVisibility));
            }
        }

        public void onVisibilityChanged(int visibility) {
            this.mVisibility = visibility;
            if (!this.isDisposed()) {
                this.mObserver.onNext((Object)new SlideUpEvent(this.mSlideUp, this.mPercent, this.mVisibility));
            }
        }
    }
}

