/*
 * Decompiled with CFR 0.152.
 */
package ru.ztrap.rxslideup;

import com.mancj.slideup.SlideUp;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import ru.ztrap.rxslideup.SlideUpObservable;
import ru.ztrap.rxslideup.ThreadUtils;

final class SlideObservable
extends Observable<Float> {
    private final SlideUp mSlideUp;

    SlideObservable(SlideUp slideUp) {
        this.mSlideUp = slideUp;
    }

    protected void subscribeActual(Observer<? super Float> observer) {
        if (ThreadUtils.checkNotMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.mSlideUp, observer);
        observer.onSubscribe((Disposable)listener);
        this.mSlideUp.addSlideListener((SlideUp.Listener)listener);
        if (!this.mSlideUp.isAnimationRunning() && !listener.isDisposed()) {
            listener.mObserver.onNext((Object)Float.valueOf(this.mSlideUp.isVisible() ? 0.0f : 100.0f));
        }
    }

    final class Listener
    extends SlideUpObservable<Float>
    implements SlideUp.Listener.Slide {
        Listener(SlideUp slideUp, Observer<? super Float> observer) {
            super(slideUp, observer);
        }

        protected void onDispose() {
            this.mSlideUp.removeSlideListener((SlideUp.Listener)this);
        }

        public void onSlide(float v) {
            if (!this.isDisposed()) {
                this.mObserver.onNext((Object)Float.valueOf(v));
            }
        }
    }
}

