/*
 * Decompiled with CFR 0.152.
 */
package ru.ztrap.rxslideup;

import com.mancj.slideup.SlideUp;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import ru.ztrap.rxslideup.SlideUpObservable;
import ru.ztrap.rxslideup.ThreadUtils;

final class VisibilityObservable
extends Observable<Integer> {
    private final SlideUp mSlideUp;

    VisibilityObservable(SlideUp slideUp) {
        this.mSlideUp = slideUp;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (ThreadUtils.checkNotMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.mSlideUp, observer);
        observer.onSubscribe((Disposable)listener);
        this.mSlideUp.addSlideListener((SlideUp.Listener)listener);
        if (!this.mSlideUp.isAnimationRunning() && !listener.isDisposed()) {
            listener.mObserver.onNext((Object)this.mSlideUp.getSliderView().getVisibility());
        }
    }

    final class Listener
    extends SlideUpObservable<Integer>
    implements SlideUp.Listener.Visibility {
        Listener(SlideUp slideUp, Observer<? super Integer> observer) {
            super(slideUp, observer);
        }

        protected void onDispose() {
            this.mSlideUp.removeSlideListener((SlideUp.Listener)this);
        }

        public void onVisibilityChanged(int i) {
            if (!this.isDisposed()) {
                this.mObserver.onNext((Object)i);
            }
        }
    }
}

