/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;

public class HaloExtension {
    public static final String EXTENSION_NAME = "halo";
    private String imageName = "halohub/halo";
    private String containerName = "halo-for-plugin-development";
    private String serverWorkDir = "/root/.halo2";
    private String version = "2.5.2";
    private String externalUrl = "http://localhost:8090";
    private String superAdminUsername = "admin";
    private String superAdminPassword = "admin";
    private Docker docker;

    public HaloExtension(ObjectFactory objectFactory) {
        this.docker = new Docker(objectFactory);
    }

    public void docker(Action<? super Docker> action) {
        action.execute((Object)this.docker);
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getServerWorkDir() {
        return this.serverWorkDir;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public String getSuperAdminUsername() {
        return this.superAdminUsername;
    }

    public String getSuperAdminPassword() {
        return this.superAdminPassword;
    }

    public Docker getDocker() {
        return this.docker;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public void setServerWorkDir(String serverWorkDir) {
        this.serverWorkDir = serverWorkDir;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public void setSuperAdminUsername(String superAdminUsername) {
        this.superAdminUsername = superAdminUsername;
    }

    public void setSuperAdminPassword(String superAdminPassword) {
        this.superAdminPassword = superAdminPassword;
    }

    public void setDocker(Docker docker) {
        this.docker = docker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaloExtension)) {
            return false;
        }
        HaloExtension other = (HaloExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$imageName = this.getImageName();
        String other$imageName = other.getImageName();
        if (this$imageName == null ? other$imageName != null : !this$imageName.equals(other$imageName)) {
            return false;
        }
        String this$containerName = this.getContainerName();
        String other$containerName = other.getContainerName();
        if (this$containerName == null ? other$containerName != null : !this$containerName.equals(other$containerName)) {
            return false;
        }
        String this$serverWorkDir = this.getServerWorkDir();
        String other$serverWorkDir = other.getServerWorkDir();
        if (this$serverWorkDir == null ? other$serverWorkDir != null : !this$serverWorkDir.equals(other$serverWorkDir)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$externalUrl = this.getExternalUrl();
        String other$externalUrl = other.getExternalUrl();
        if (this$externalUrl == null ? other$externalUrl != null : !this$externalUrl.equals(other$externalUrl)) {
            return false;
        }
        String this$superAdminUsername = this.getSuperAdminUsername();
        String other$superAdminUsername = other.getSuperAdminUsername();
        if (this$superAdminUsername == null ? other$superAdminUsername != null : !this$superAdminUsername.equals(other$superAdminUsername)) {
            return false;
        }
        String this$superAdminPassword = this.getSuperAdminPassword();
        String other$superAdminPassword = other.getSuperAdminPassword();
        if (this$superAdminPassword == null ? other$superAdminPassword != null : !this$superAdminPassword.equals(other$superAdminPassword)) {
            return false;
        }
        Docker this$docker = this.getDocker();
        Docker other$docker = other.getDocker();
        return !(this$docker == null ? other$docker != null : !this$docker.equals(other$docker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaloExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $imageName = this.getImageName();
        result = result * 59 + ($imageName == null ? 43 : $imageName.hashCode());
        String $containerName = this.getContainerName();
        result = result * 59 + ($containerName == null ? 43 : $containerName.hashCode());
        String $serverWorkDir = this.getServerWorkDir();
        result = result * 59 + ($serverWorkDir == null ? 43 : $serverWorkDir.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $externalUrl = this.getExternalUrl();
        result = result * 59 + ($externalUrl == null ? 43 : $externalUrl.hashCode());
        String $superAdminUsername = this.getSuperAdminUsername();
        result = result * 59 + ($superAdminUsername == null ? 43 : $superAdminUsername.hashCode());
        String $superAdminPassword = this.getSuperAdminPassword();
        result = result * 59 + ($superAdminPassword == null ? 43 : $superAdminPassword.hashCode());
        Docker $docker = this.getDocker();
        result = result * 59 + ($docker == null ? 43 : $docker.hashCode());
        return result;
    }

    public String toString() {
        return "HaloExtension(imageName=" + this.getImageName() + ", containerName=" + this.getContainerName() + ", serverWorkDir=" + this.getServerWorkDir() + ", version=" + this.getVersion() + ", externalUrl=" + this.getExternalUrl() + ", superAdminUsername=" + this.getSuperAdminUsername() + ", superAdminPassword=" + this.getSuperAdminPassword() + ", docker=" + this.getDocker() + ")";
    }

    public static class Docker {
        static final String DEFAULT_DOCKER_HOST = "unix:///var/run/docker.sock";
        static final String WINDOWS_DEFAULT_DOCKER_HOST = "npipe:////./pipe/docker_engine";
        private final Property<String> url;
        private final Property<String> apiVersion;

        public Docker(ObjectFactory objectFactory) {
            this.url = objectFactory.property(String.class);
            this.url.convention((Object)this.getDefaultDockerUrl());
            this.apiVersion = objectFactory.property(String.class);
        }

        public final Property<String> getApiVersion() {
            return this.apiVersion;
        }

        public final Property<String> getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url.set((Object)url);
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion.set((Object)apiVersion);
        }

        String getDefaultDockerUrl() {
            return SystemUtils.IS_OS_WINDOWS ? WINDOWS_DEFAULT_DOCKER_HOST : DEFAULT_DOCKER_HOST;
        }
    }
}

