/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import run.halo.gradle.watch.WatchTarget;

public class HaloPluginExtension {
    public static final String[] MANIFEST = new String[]{"plugin.yaml", "plugin.yml"};
    public static final String EXTENSION_NAME = "haloPlugin";
    private Path workDir;
    private String pluginName;
    private String requires;
    private String version;
    private final Property<String> mainClass;
    private File manifestFile;
    private NamedDomainObjectContainer<WatchTarget> watchDomains;

    public Property<String> getMainClass() {
        return this.mainClass;
    }

    public HaloPluginExtension(Project project) {
        this.watchDomains = project.container(WatchTarget.class);
        this.mainClass = project.getObjects().property(String.class);
    }

    public String getRequires() {
        if (this.requires == null || "*".equals(this.requires)) {
            return "latest";
        }
        return this.requires;
    }

    public void watchDomain(Action<NamedDomainObjectContainer<WatchTarget>> action) {
        action.execute(this.watchDomains);
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getVersion() {
        return this.version;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public NamedDomainObjectContainer<WatchTarget> getWatchDomains() {
        return this.watchDomains;
    }

    public void setWorkDir(Path workDir) {
        this.workDir = workDir;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setRequires(String requires) {
        this.requires = requires;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public void setWatchDomains(NamedDomainObjectContainer<WatchTarget> watchDomains) {
        this.watchDomains = watchDomains;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HaloPluginExtension)) {
            return false;
        }
        HaloPluginExtension other = (HaloPluginExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$workDir = this.getWorkDir();
        Path other$workDir = other.getWorkDir();
        if (this$workDir == null ? other$workDir != null : !((Object)this$workDir).equals(other$workDir)) {
            return false;
        }
        String this$pluginName = this.getPluginName();
        String other$pluginName = other.getPluginName();
        if (this$pluginName == null ? other$pluginName != null : !this$pluginName.equals(other$pluginName)) {
            return false;
        }
        String this$requires = this.getRequires();
        String other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !this$requires.equals(other$requires)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Property<String> this$mainClass = this.getMainClass();
        Property<String> other$mainClass = other.getMainClass();
        if (this$mainClass == null ? other$mainClass != null : !this$mainClass.equals(other$mainClass)) {
            return false;
        }
        File this$manifestFile = this.getManifestFile();
        File other$manifestFile = other.getManifestFile();
        if (this$manifestFile == null ? other$manifestFile != null : !((Object)this$manifestFile).equals(other$manifestFile)) {
            return false;
        }
        NamedDomainObjectContainer<WatchTarget> this$watchDomains = this.getWatchDomains();
        NamedDomainObjectContainer<WatchTarget> other$watchDomains = other.getWatchDomains();
        return !(this$watchDomains == null ? other$watchDomains != null : !this$watchDomains.equals(other$watchDomains));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HaloPluginExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $workDir = this.getWorkDir();
        result = result * 59 + ($workDir == null ? 43 : ((Object)$workDir).hashCode());
        String $pluginName = this.getPluginName();
        result = result * 59 + ($pluginName == null ? 43 : $pluginName.hashCode());
        String $requires = this.getRequires();
        result = result * 59 + ($requires == null ? 43 : $requires.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Property<String> $mainClass = this.getMainClass();
        result = result * 59 + ($mainClass == null ? 43 : $mainClass.hashCode());
        File $manifestFile = this.getManifestFile();
        result = result * 59 + ($manifestFile == null ? 43 : ((Object)$manifestFile).hashCode());
        NamedDomainObjectContainer<WatchTarget> $watchDomains = this.getWatchDomains();
        result = result * 59 + ($watchDomains == null ? 43 : $watchDomains.hashCode());
        return result;
    }

    public String toString() {
        return "HaloPluginExtension(workDir=" + this.getWorkDir() + ", pluginName=" + this.getPluginName() + ", requires=" + this.getRequires() + ", version=" + this.getVersion() + ", mainClass=" + this.getMainClass() + ", manifestFile=" + this.getManifestFile() + ", watchDomains=" + this.getWatchDomains() + ")";
    }
}

