/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;

public class PluginArchiveSupport {
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final String UNSPECIFIED_VERSION = "unspecified";
    private final String pluginMainClass;

    PluginArchiveSupport(String pluginMainClass) {
        this.pluginMainClass = pluginMainClass;
    }

    void configureManifest(Manifest manifest, String lib, String jdkVersion, String implementationTitle, Object implementationVersion) {
        String versionString;
        Attributes attributes = manifest.getAttributes();
        attributes.putIfAbsent((Object)"Plugin-Main-Class", (Object)this.pluginMainClass);
        attributes.putIfAbsent((Object)"Build-Jdk-Spec", (Object)jdkVersion);
        attributes.putIfAbsent((Object)"Implementation-Title", (Object)implementationTitle);
        if (implementationVersion != null && !UNSPECIFIED_VERSION.equals(versionString = implementationVersion.toString())) {
            attributes.putIfAbsent((Object)"Implementation-Version", (Object)versionString);
        }
    }

    boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (byte headerByte : ZIP_FILE_HEADER) {
            if (inputStream.read() == headerByte) continue;
            return false;
        }
        return true;
    }
}

