/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    public static void withRetry(int maxTimes, long baseSleepMillis, CallToRetry call) {
        if (maxTimes <= 0) {
            throw new IllegalArgumentException("Must run at least one time");
        }
        if (baseSleepMillis <= 0L) {
            throw new IllegalArgumentException("Initial wait must be at least 1");
        }
        Exception thrown = null;
        for (int i = 0; i < maxTimes; ++i) {
            try {
                boolean result = call.process();
                if (result) {
                    break;
                }
            }
            catch (Exception e) {
                thrown = e;
                log.debug("Encountered failure on {} due to {}, attempt retry {} of {}", new Object[]{call.getClass().getName(), e.getMessage(), i + 1, maxTimes, e});
            }
            try {
                long sleepTime = baseSleepMillis * (long)Math.pow(i + 1, 2.0);
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException wakeAndAbort) {
                break;
            }
        }
        if (thrown != null) {
            throw new IllegalStateException("Execution timeout:" + thrown);
        }
    }

    public static interface CallToRetry {
        public boolean process() throws Exception;
    }
}

