/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.gradle.internal.classpath.ClassPath;

public final class WatchExecutionParameters {
    @NonNull
    private final File projectDir;
    private final List<String> buildArgs;
    private final List<String> jvmArgs;
    private final ClassPath injectedClassPath;
    private final boolean embedded;
    private final OutputStream standardOutput;
    private final OutputStream standardError;
    private final InputStream standardInput;
    private final Map<String, String> environment;

    private static List<String> $default$buildArgs() {
        return List.of("-q");
    }

    private static List<String> $default$jvmArgs() {
        return List.of();
    }

    private static OutputStream $default$standardOutput() {
        return System.out;
    }

    private static OutputStream $default$standardError() {
        return System.err;
    }

    private static Map<String, String> $default$environment() {
        return new LinkedHashMap<String, String>();
    }

    WatchExecutionParameters(@NonNull File projectDir, List<String> buildArgs, List<String> jvmArgs, ClassPath injectedClassPath, boolean embedded, OutputStream standardOutput, OutputStream standardError, InputStream standardInput, Map<String, String> environment) {
        if (projectDir == null) {
            throw new NullPointerException("projectDir is marked non-null but is null");
        }
        this.projectDir = projectDir;
        this.buildArgs = buildArgs;
        this.jvmArgs = jvmArgs;
        this.injectedClassPath = injectedClassPath;
        this.embedded = embedded;
        this.standardOutput = standardOutput;
        this.standardError = standardError;
        this.standardInput = standardInput;
        this.environment = environment;
    }

    public static WatchExecutionParametersBuilder builder() {
        return new WatchExecutionParametersBuilder();
    }

    @NonNull
    public File getProjectDir() {
        return this.projectDir;
    }

    public List<String> getBuildArgs() {
        return this.buildArgs;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public ClassPath getInjectedClassPath() {
        return this.injectedClassPath;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public OutputStream getStandardError() {
        return this.standardError;
    }

    public InputStream getStandardInput() {
        return this.standardInput;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatchExecutionParameters)) {
            return false;
        }
        WatchExecutionParameters other = (WatchExecutionParameters)o;
        if (this.isEmbedded() != other.isEmbedded()) {
            return false;
        }
        File this$projectDir = this.getProjectDir();
        File other$projectDir = other.getProjectDir();
        if (this$projectDir == null ? other$projectDir != null : !((Object)this$projectDir).equals(other$projectDir)) {
            return false;
        }
        List<String> this$buildArgs = this.getBuildArgs();
        List<String> other$buildArgs = other.getBuildArgs();
        if (this$buildArgs == null ? other$buildArgs != null : !((Object)this$buildArgs).equals(other$buildArgs)) {
            return false;
        }
        List<String> this$jvmArgs = this.getJvmArgs();
        List<String> other$jvmArgs = other.getJvmArgs();
        if (this$jvmArgs == null ? other$jvmArgs != null : !((Object)this$jvmArgs).equals(other$jvmArgs)) {
            return false;
        }
        ClassPath this$injectedClassPath = this.getInjectedClassPath();
        ClassPath other$injectedClassPath = other.getInjectedClassPath();
        if (this$injectedClassPath == null ? other$injectedClassPath != null : !this$injectedClassPath.equals(other$injectedClassPath)) {
            return false;
        }
        OutputStream this$standardOutput = this.getStandardOutput();
        OutputStream other$standardOutput = other.getStandardOutput();
        if (this$standardOutput == null ? other$standardOutput != null : !this$standardOutput.equals(other$standardOutput)) {
            return false;
        }
        OutputStream this$standardError = this.getStandardError();
        OutputStream other$standardError = other.getStandardError();
        if (this$standardError == null ? other$standardError != null : !this$standardError.equals(other$standardError)) {
            return false;
        }
        InputStream this$standardInput = this.getStandardInput();
        InputStream other$standardInput = other.getStandardInput();
        if (this$standardInput == null ? other$standardInput != null : !this$standardInput.equals(other$standardInput)) {
            return false;
        }
        Map<String, String> this$environment = this.getEnvironment();
        Map<String, String> other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEmbedded() ? 79 : 97);
        File $projectDir = this.getProjectDir();
        result = result * 59 + ($projectDir == null ? 43 : ((Object)$projectDir).hashCode());
        List<String> $buildArgs = this.getBuildArgs();
        result = result * 59 + ($buildArgs == null ? 43 : ((Object)$buildArgs).hashCode());
        List<String> $jvmArgs = this.getJvmArgs();
        result = result * 59 + ($jvmArgs == null ? 43 : ((Object)$jvmArgs).hashCode());
        ClassPath $injectedClassPath = this.getInjectedClassPath();
        result = result * 59 + ($injectedClassPath == null ? 43 : $injectedClassPath.hashCode());
        OutputStream $standardOutput = this.getStandardOutput();
        result = result * 59 + ($standardOutput == null ? 43 : $standardOutput.hashCode());
        OutputStream $standardError = this.getStandardError();
        result = result * 59 + ($standardError == null ? 43 : $standardError.hashCode());
        InputStream $standardInput = this.getStandardInput();
        result = result * 59 + ($standardInput == null ? 43 : $standardInput.hashCode());
        Map<String, String> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        return result;
    }

    public String toString() {
        return "WatchExecutionParameters(projectDir=" + this.getProjectDir() + ", buildArgs=" + this.getBuildArgs() + ", jvmArgs=" + this.getJvmArgs() + ", injectedClassPath=" + this.getInjectedClassPath() + ", embedded=" + this.isEmbedded() + ", standardOutput=" + this.getStandardOutput() + ", standardError=" + this.getStandardError() + ", standardInput=" + this.getStandardInput() + ", environment=" + this.getEnvironment() + ")";
    }

    public static class WatchExecutionParametersBuilder {
        private File projectDir;
        private boolean buildArgs$set;
        private List<String> buildArgs$value;
        private boolean jvmArgs$set;
        private List<String> jvmArgs$value;
        private ClassPath injectedClassPath;
        private boolean embedded;
        private boolean standardOutput$set;
        private OutputStream standardOutput$value;
        private boolean standardError$set;
        private OutputStream standardError$value;
        private InputStream standardInput;
        private boolean environment$set;
        private Map<String, String> environment$value;

        WatchExecutionParametersBuilder() {
        }

        public WatchExecutionParametersBuilder projectDir(@NonNull File projectDir) {
            if (projectDir == null) {
                throw new NullPointerException("projectDir is marked non-null but is null");
            }
            this.projectDir = projectDir;
            return this;
        }

        public WatchExecutionParametersBuilder buildArgs(List<String> buildArgs) {
            this.buildArgs$value = buildArgs;
            this.buildArgs$set = true;
            return this;
        }

        public WatchExecutionParametersBuilder jvmArgs(List<String> jvmArgs) {
            this.jvmArgs$value = jvmArgs;
            this.jvmArgs$set = true;
            return this;
        }

        public WatchExecutionParametersBuilder injectedClassPath(ClassPath injectedClassPath) {
            this.injectedClassPath = injectedClassPath;
            return this;
        }

        public WatchExecutionParametersBuilder embedded(boolean embedded) {
            this.embedded = embedded;
            return this;
        }

        public WatchExecutionParametersBuilder standardOutput(OutputStream standardOutput) {
            this.standardOutput$value = standardOutput;
            this.standardOutput$set = true;
            return this;
        }

        public WatchExecutionParametersBuilder standardError(OutputStream standardError) {
            this.standardError$value = standardError;
            this.standardError$set = true;
            return this;
        }

        public WatchExecutionParametersBuilder standardInput(InputStream standardInput) {
            this.standardInput = standardInput;
            return this;
        }

        public WatchExecutionParametersBuilder environment(Map<String, String> environment) {
            this.environment$value = environment;
            this.environment$set = true;
            return this;
        }

        public WatchExecutionParameters build() {
            List<String> buildArgs$value = this.buildArgs$value;
            if (!this.buildArgs$set) {
                buildArgs$value = WatchExecutionParameters.$default$buildArgs();
            }
            List<String> jvmArgs$value = this.jvmArgs$value;
            if (!this.jvmArgs$set) {
                jvmArgs$value = WatchExecutionParameters.$default$jvmArgs();
            }
            OutputStream standardOutput$value = this.standardOutput$value;
            if (!this.standardOutput$set) {
                standardOutput$value = WatchExecutionParameters.$default$standardOutput();
            }
            OutputStream standardError$value = this.standardError$value;
            if (!this.standardError$set) {
                standardError$value = WatchExecutionParameters.$default$standardError();
            }
            Map<String, String> environment$value = this.environment$value;
            if (!this.environment$set) {
                environment$value = WatchExecutionParameters.$default$environment();
            }
            return new WatchExecutionParameters(this.projectDir, buildArgs$value, jvmArgs$value, this.injectedClassPath, this.embedded, standardOutput$value, standardError$value, this.standardInput, environment$value);
        }

        public String toString() {
            return "WatchExecutionParameters.WatchExecutionParametersBuilder(projectDir=" + this.projectDir + ", buildArgs$value=" + this.buildArgs$value + ", jvmArgs$value=" + this.jvmArgs$value + ", injectedClassPath=" + this.injectedClassPath + ", embedded=" + this.embedded + ", standardOutput$value=" + this.standardOutput$value + ", standardError$value=" + this.standardError$value + ", standardInput=" + this.standardInput + ", environment$value=" + this.environment$value + ")";
        }
    }
}

