/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.nio.file.Path;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import run.halo.gradle.YamlUtils;

public class YamlPluginVersionSupport {
    public static Action<Task> configurePluginYamlVersion(final Project project, File manifestFile) {
        File file = ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getOutput().getResourcesDir();
        if (file == null) {
            throw new RuntimeException("Can not find resources dir.");
        }
        final Path outputPluginYaml = file.toPath().resolve(manifestFile.getName());
        Action<Task> action = new Action<Task>(){

            public void execute(@NonNull Task task) {
                if (task == null) {
                    throw new NullPointerException("task is marked non-null but is null");
                }
                YamlPluginVersionSupport.rewritePluginYaml(outputPluginYaml.toFile(), project);
            }
        };
        return action;
    }

    private static void rewritePluginYaml(File outputPluginYaml, Project project) {
        YamlUtils.write(outputPluginYaml, pluginYaml -> {
            JsonNode spec = pluginYaml.get("spec");
            if (spec == null || spec.isNull()) {
                ObjectNode node = (ObjectNode)pluginYaml;
                spec = node.putObject("spec");
            }
            ((ObjectNode)spec).put("version", YamlPluginVersionSupport.getProjectVersion(project));
            return pluginYaml;
        }, outputPluginYaml);
    }

    private static String getProjectVersion(Project project) {
        String version = (String)project.getVersion();
        if (StringUtils.equals((CharSequence)"unspecified", (CharSequence)version)) {
            throw new IllegalStateException("Project version must be set.");
        }
        return version;
    }
}

