/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.DockerClient;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import run.halo.gradle.docker.DockerClientConfiguration;
import run.halo.gradle.docker.DockerClientService;

public abstract class AbstractDockerRemoteApiTask
extends DefaultTask {
    private final Property<String> url = this.getProject().getObjects().property(String.class);
    private final DirectoryProperty certPath = this.getProject().getObjects().directoryProperty();
    private final Property<String> apiVersion = this.getProject().getObjects().property(String.class);
    private final Property<DockerClientService> dockerClientService = this.getProject().getObjects().property(DockerClientService.class);
    private Action<? super Throwable> errorHandler;
    private Action<? super Object> nextHandler;
    private Runnable completeHandler;

    @Input
    @Optional
    public final Property<String> getUrl() {
        return this.url;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    public final DirectoryProperty getCertPath() {
        return this.certPath;
    }

    @Input
    @Optional
    public final Property<String> getApiVersion() {
        return this.apiVersion;
    }

    @Internal
    public final Property<DockerClientService> getDockerClientService() {
        return this.dockerClientService;
    }

    @TaskAction
    public void start() throws Exception {
        boolean commandFailed = false;
        try {
            this.runRemoteCommand();
        }
        catch (Exception possibleException) {
            commandFailed = true;
            if (this.errorHandler != null) {
                this.errorHandler.execute((Object)possibleException);
            }
            throw possibleException;
        }
        if (!commandFailed && this.completeHandler != null) {
            this.completeHandler.run();
        }
    }

    public void onError(Action<? super Throwable> action) {
        this.errorHandler = action;
    }

    public void onNext(Action<? super Object> action) {
        this.nextHandler = action;
    }

    @Internal
    protected Action<? super Object> getNextHandler() {
        return this.nextHandler;
    }

    public void onComplete(Runnable callback) {
        this.completeHandler = callback;
    }

    @Internal
    public DockerClient getDockerClient() {
        return ((DockerClientService)this.dockerClientService.get()).getDockerClient(this.createDockerClientConfig());
    }

    private DockerClientConfiguration createDockerClientConfig() {
        DockerClientConfiguration dockerClientConfig = new DockerClientConfiguration();
        dockerClientConfig.setUrl((String)this.url.getOrNull());
        dockerClientConfig.setCertPath((Directory)this.certPath.getOrNull());
        dockerClientConfig.setApiVersion((String)this.apiVersion.getOrNull());
        return dockerClientConfig;
    }

    public abstract void runRemoteCommand() throws Exception;
}

