/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContainerExistsStep {
    private static final Logger log = LoggerFactory.getLogger(CheckContainerExistsStep.class);
    private final String containerId;
    private final DockerClient dockerClient;

    public CheckContainerExistsStep(DockerClient dockerClient, String containerId) {
        this.containerId = containerId;
        this.dockerClient = dockerClient;
    }

    public boolean execute() {
        boolean bl;
        block8: {
            InspectContainerCmd inspectContainerCmd = this.dockerClient.inspectContainerCmd(this.containerId);
            try {
                InspectContainerResponse containerResponse = inspectContainerCmd.exec();
                bl = this.validateContainerResponse(containerResponse);
                if (inspectContainerCmd == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inspectContainerCmd != null) {
                        try {
                            inspectContainerCmd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.debug("Failed to inspect container with ID: " + this.containerId);
                    return false;
                }
            }
            inspectContainerCmd.close();
        }
        return bl;
    }

    private boolean validateContainerResponse(InspectContainerResponse containerResponse) {
        if (containerResponse == null) {
            return false;
        }
        String containerId = containerResponse.getId();
        ContainerConfig config = containerResponse.getConfig();
        Map labels = config.getLabels();
        if (labels == null || !labels.containsKey("halo.container.createdBy")) {
            throw new IllegalStateException("Container with ID [" + containerId + "] already exists and not was created by this plugin. Please remove the container before running this task again.");
        }
        return true;
    }
}

