/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.HaloExtension;
import run.halo.gradle.HaloPluginExtension;
import run.halo.gradle.docker.DockerExistingImage;
import run.halo.gradle.utils.PathUtils;

public class DockerCreateContainer
extends DockerExistingImage {
    private static final Logger log = LoggerFactory.getLogger(DockerCreateContainer.class);
    private final HaloPluginExtension pluginExtension = (HaloPluginExtension)this.getProject().getExtensions().getByType(HaloPluginExtension.class);
    private final HaloExtension haloExtension = (HaloExtension)this.getProject().getExtensions().getByType(HaloExtension.class);
    @Input
    @Optional
    final Property<String> containerName = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<String> workingDir = this.getProject().getObjects().property(String.class);
    @OutputFile
    final RegularFileProperty containerIdFile = this.getProject().getObjects().fileProperty();
    @Internal
    final Property<String> containerId = this.getProject().getObjects().property(String.class);
    @Input
    @Optional
    final Property<String> platform = this.getProject().getObjects().property(String.class);

    public DockerCreateContainer() {
        this.containerId.convention(this.containerIdFile.map((Transformer)new RegularFileToStringTransformer()));
        String safeTaskPath = this.getPath().replaceFirst("^:", "").replaceAll(":", "_");
        this.containerIdFile.convention(this.getProject().getLayout().getBuildDirectory().file(".docker/" + safeTaskPath + "-containerId.txt"));
        this.getOutputs().upToDateWhen(this.getUpToDateWhenSpec());
    }

    private Spec<Task> getUpToDateWhenSpec() {
        return element -> {
            File file = ((RegularFile)this.getContainerIdFile().get()).getAsFile();
            if (file.exists()) {
                try {
                    String fileContainerId;
                    try {
                        fileContainerId = Files.readString(file.toPath());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    try (InspectContainerCmd inspectContainerCmd = this.getDockerClient().inspectContainerCmd(fileContainerId);){
                        inspectContainerCmd.exec();
                    }
                    return true;
                }
                catch (DockerException dockerException) {
                    // empty catch block
                }
            }
            return false;
        };
    }

    @Override
    public void runRemoteCommand() throws Exception {
        String imageId = (String)this.getImageId().get();
        CreateContainerCmd containerCommand = this.getDockerClient().createContainerCmd(imageId);
        this.setContainerCommandConfig(containerCommand);
        CreateContainerResponse container = containerCommand.exec();
        String localContainerName = this.containerName.getOrNull() == null ? container.getId() : (String)this.containerName.get();
        log.info("Created container with ID [{}]", (Object)localContainerName);
        Files.writeString(((RegularFile)this.containerIdFile.get()).getAsFile().toPath(), (CharSequence)container.getId(), new OpenOption[0]);
        Action<? super Object> nextHandler = this.getNextHandler();
        if (nextHandler != null) {
            nextHandler.execute((Object)container);
        }
    }

    private void setContainerCommandConfig(CreateContainerCmd containerCommand) {
        if (this.containerName.getOrNull() != null) {
            containerCommand.withName((String)this.containerName.get());
        }
        if (this.workingDir.getOrNull() != null) {
            containerCommand.withWorkingDir((String)this.workingDir.get());
        }
        if (this.platform.getOrNull() != null) {
            containerCommand.withPlatform((String)this.platform.get());
        }
        containerCommand.withCmd(new String[]{"--rm"});
        String pluginName = this.pluginExtension.getPluginName();
        Integer debugPort = this.debugPort();
        ArrayList<Object> envs = new ArrayList<Object>();
        envs.add("HALO_EXTERNAL_URL=" + this.haloExtension.getExternalUrl());
        envs.add("HALO_SECURITY_INITIALIZER_SUPERADMINPASSWORD=" + this.haloExtension.getSuperAdminPassword());
        envs.add("HALO_SECURITY_INITIALIZER_SUPERADMINUSERNAME=" + this.haloExtension.getSuperAdminUsername());
        if (debugPort != null) {
            envs.add("JAVA_TOOL_OPTIONS=-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:" + debugPort);
        }
        envs.add("HALO_PLUGIN_RUNTIMEMODE=development");
        envs.add("HALO_PLUGIN_FIXEDPLUGINPATH=" + Paths.get(this.buildPluginDestPath(pluginName), new String[0]));
        envs.add("HALO_WORKDIR=" + this.haloWorkDir());
        String configLocation = PathUtils.combinePath(this.haloWorkDir(), "/config") + "/";
        envs.add("SPRING_CONFIG_IMPORT=optional:file:" + configLocation + ";optional:file:" + configLocation + "*/");
        containerCommand.withEnv(envs);
        containerCommand.withImage((String)this.getImageId().get());
        containerCommand.withLabels(Map.of("halo.container.createdBy", "halo-gradle-plugin"));
        ArrayList<ExposedPort> exposedPorts = new ArrayList<ExposedPort>(2);
        exposedPorts.add(ExposedPort.parse((String)"8090"));
        if (debugPort != null) {
            exposedPorts.add(ExposedPort.tcp((int)debugPort));
        }
        containerCommand.withExposedPorts(exposedPorts);
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>(2);
        portBindings.add(PortBinding.parse((String)"8090:8090"));
        if (debugPort != null) {
            portBindings.add(PortBinding.parse((String)(debugPort + ":" + debugPort)));
        }
        HostConfig hostConfig = new HostConfig();
        hostConfig.withPortBindings(portBindings);
        File projectDir = this.getProject().getBuildDir();
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(projectDir.toString(), new Volume(this.buildPluginDestPath(pluginName) + "build")));
        if (this.pluginExtension.getWorkDir() != null) {
            binds.add(new Bind(this.pluginExtension.getWorkDir().toString(), new Volume(this.haloWorkDir())));
        }
        hostConfig.withBinds(binds);
        containerCommand.withHostConfig(hostConfig);
    }

    String haloWorkDir() {
        return this.haloExtension.getServerWorkDir();
    }

    String buildPluginDestPath(String pluginName) {
        return "/data/plugins/" + pluginName + "/";
    }

    Integer debugPort() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = runtimeMXBean.getInputArguments();
        return inputArguments.stream().filter(argument -> argument.startsWith("-agentlib:jdwp=")).findFirst().map(this::parsePort).orElse(null);
    }

    Integer parsePort(String debugOption) {
        Pattern pattern = Pattern.compile("address=.*:(\\d{1,5})$");
        Matcher matcher = pattern.matcher(debugOption);
        if (matcher.find()) {
            String port = matcher.group(1);
            return Integer.parseInt(port);
        }
        return null;
    }

    public Property<String> getContainerName() {
        return this.containerName;
    }

    public Property<String> getWorkingDir() {
        return this.workingDir;
    }

    public RegularFileProperty getContainerIdFile() {
        return this.containerIdFile;
    }

    public Property<String> getContainerId() {
        return this.containerId;
    }

    public Property<String> getPlatform() {
        return this.platform;
    }

    public static class RegularFileToStringTransformer
    implements Transformer<String, RegularFile>,
    Serializable {
        @Nonnull
        public String transform(RegularFile it) {
            File file = it.getAsFile();
            if (file.exists()) {
                try {
                    return Files.readString(file.toPath());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return "";
        }
    }
}

