/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.model.WaitResponse;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.DockerExistingContainer;
import run.halo.gradle.docker.FrameConsumerResultCallback;
import run.halo.gradle.docker.OutputFrame;
import run.halo.gradle.docker.ToStringConsumer;

public class DockerStartContainer
extends DockerExistingContainer {
    private static final Logger log = LoggerFactory.getLogger(DockerStartContainer.class);
    private int exitCode;
    @Input
    @Optional
    private final Property<Integer> awaitStatusTimeout = this.getProject().getObjects().property(Integer.class);

    @Override
    public void runRemoteCommand() {
        FrameConsumerResultCallback callback;
        StartContainerCmd containerCommand;
        log.info("Starting container with ID [{}].", this.containerId.get());
        try {
            containerCommand = this.getDockerClient().startContainerCmd((String)this.containerId.get());
            try {
                containerCommand.exec();
            }
            finally {
                if (containerCommand != null) {
                    containerCommand.close();
                }
            }
        }
        catch (Exception e) {
            throw new GradleException("Failed to start container", (Throwable)e);
        }
        try (AttachContainerCmd attachContainerCmd = this.getDockerClient().attachContainerCmd((String)this.containerId.get());){
            callback = new FrameConsumerResultCallback();
            ToStringConsumer toStringConsumer = new ToStringConsumer();
            callback.addConsumer(OutputFrame.OutputType.STDOUT, toStringConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, toStringConsumer);
            attachContainerCmd.withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withLogs(Boolean.valueOf(true)).exec((ResultCallback)callback);
        }
        catch (Exception e) {
            throw new GradleException("Failed to attach to container", (Throwable)e);
        }
        try {
            containerCommand = this.getDockerClient().waitContainerCmd((String)this.getContainerId().get());
            try {
                callback = (WaitContainerResultCallback)containerCommand.exec((ResultCallback)this.createCallback(this.getNextHandler()));
                this.exitCode = this.awaitStatusTimeout.getOrNull() != null ? callback.awaitStatusCode(((Integer)this.awaitStatusTimeout.get()).intValue(), TimeUnit.SECONDS) : callback.awaitStatusCode();
                this.getLogger().quiet("Container exited with code " + this.getExitCode());
            }
            finally {
                if (containerCommand != null) {
                    containerCommand.close();
                }
            }
        }
        catch (Exception e) {
            throw new GradleException("Failed to wait for container to exit", (Throwable)e);
        }
    }

    @Internal
    public int getExitCode() {
        return this.exitCode;
    }

    private WaitContainerResultCallback createCallback(final Action<Object> nextHandler) {
        return new WaitContainerResultCallback(){

            public void onNext(WaitResponse waitResponse) {
                if (nextHandler != null) {
                    try {
                        nextHandler.execute((Object)waitResponse);
                    }
                    catch (Exception e) {
                        DockerStartContainer.this.getLogger().error("Failed to handle wait response", (Throwable)e);
                        return;
                    }
                }
                super.onNext(waitResponse);
            }
        };
    }

    public Property<Integer> getAwaitStatusTimeout() {
        return this.awaitStatusTimeout;
    }
}

