/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.StopContainerCmd;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.DockerExistingContainer;

public class DockerStopContainer
extends DockerExistingContainer {
    private static final Logger log = LoggerFactory.getLogger(DockerStopContainer.class);
    @Input
    @Optional
    final Property<Integer> waitTime = this.getProject().getObjects().property(Integer.class);

    @Override
    public void runRemoteCommand() {
        log.info("Stopping container with ID [{}].", this.containerId.get());
        DockerStopContainer.runRemoteCommand(this.getDockerClient(), (String)this.containerId.get(), (Integer)this.waitTime.getOrNull());
    }

    static void runRemoteCommand(DockerClient dockerClient, String containerId, Integer optionalTimeout) {
        StopContainerCmd stopContainerCmd = dockerClient.stopContainerCmd(containerId);
        if (optionalTimeout != null) {
            stopContainerCmd.withTimeout(optionalTimeout);
        }
        stopContainerCmd.exec();
    }

    public Property<Integer> getWaitTime() {
        return this.waitTime;
    }
}

