/*
 * Decompiled with CFR 0.152.
 */
package run.halo.gradle.docker;

import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.halo.gradle.docker.BaseConsumer;
import run.halo.gradle.docker.OutputFrame;

public class FrameConsumerResultCallback
extends ResultCallbackTemplate<FrameConsumerResultCallback, Frame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameConsumerResultCallback.class);
    private static final byte[] EMPTY_LINE = new byte[0];
    private static final Pattern ANSI_COLOR_PATTERN = Pattern.compile("\u001b\\[[0-9;]+m");
    private static final String LINE_BREAK_REGEX = "((\\r?\\n)|(\\r))";
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("((\\r?\\n)|(\\r))");
    static final Pattern LINE_BREAK_AT_END_PATTERN = Pattern.compile("((\\r?\\n)|(\\r))$");
    private final Map<OutputFrame.OutputType, Consumer<OutputFrame>> consumers;
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final StringBuilder logString = new StringBuilder();
    private OutputFrame brokenFrame;

    public FrameConsumerResultCallback() {
        this.consumers = new HashMap<OutputFrame.OutputType, Consumer<OutputFrame>>();
    }

    public void addConsumer(OutputFrame.OutputType outputType, Consumer<OutputFrame> consumer) {
        this.consumers.put(outputType, consumer);
    }

    public void onNext(Frame frame) {
        OutputFrame outputFrame;
        if (frame != null && (outputFrame = OutputFrame.forFrame(frame)) != null) {
            Consumer<OutputFrame> consumer = this.consumers.get((Object)outputFrame.getType());
            if (consumer == null) {
                LOGGER.error("got frame with type {}, for which no handler is configured", (Object)frame.getStreamType());
            } else if (outputFrame.getBytes() != null && outputFrame.getBytes().length > 0) {
                if (frame.getStreamType() == StreamType.RAW) {
                    this.processRawFrame(outputFrame, consumer);
                } else {
                    this.processOtherFrame(outputFrame, consumer);
                }
            }
        }
    }

    public void onError(Throwable throwable) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        OutputFrame lastLine = null;
        if (this.logString.length() > 0) {
            lastLine = new OutputFrame(OutputFrame.OutputType.STDOUT, this.logString.toString().getBytes());
        }
        for (Consumer<OutputFrame> consumer : new HashSet<Consumer<OutputFrame>>(this.consumers.values())) {
            if (lastLine != null) {
                consumer.accept(lastLine);
            }
            consumer.accept(OutputFrame.END);
        }
        super.close();
        this.completionLatch.countDown();
    }

    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }

    private synchronized void processRawFrame(OutputFrame outputFrame, Consumer<OutputFrame> consumer) {
        int lastCharacterType;
        String utf8String = outputFrame.getUtf8String();
        byte[] bytes = outputFrame.getBytes();
        if (this.brokenFrame != null) {
            bytes = this.merge(this.brokenFrame.getBytes(), bytes);
            utf8String = new String(bytes);
            this.brokenFrame = null;
        }
        if ((lastCharacterType = Character.getType(utf8String.charAt(utf8String.length() - 1))) == 28) {
            this.brokenFrame = new OutputFrame(outputFrame.getType(), bytes);
            return;
        }
        utf8String = this.processAnsiColorCodes(utf8String, consumer);
        this.normalizeLogLines(utf8String, consumer);
    }

    private synchronized void processOtherFrame(OutputFrame outputFrame, Consumer<OutputFrame> consumer) {
        String utf8String = outputFrame.getUtf8String();
        utf8String = this.processAnsiColorCodes(utf8String, consumer);
        consumer.accept(new OutputFrame(outputFrame.getType(), utf8String.getBytes()));
    }

    private void normalizeLogLines(String utf8String, Consumer<OutputFrame> consumer) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(LINE_BREAK_PATTERN.split(utf8String)));
        if (lines.isEmpty()) {
            consumer.accept(new OutputFrame(OutputFrame.OutputType.STDOUT, EMPTY_LINE));
            return;
        }
        if (utf8String.startsWith("\n") || utf8String.startsWith("\r")) {
            lines.add(0, "");
        }
        if (utf8String.endsWith("\n") || utf8String.endsWith("\r")) {
            lines.add("");
        }
        for (int i = 0; i < lines.size() - 1; ++i) {
            Object line = (String)lines.get(i);
            if (i == 0 && this.logString.length() > 0) {
                line = this.logString.toString() + (String)line;
                this.logString.setLength(0);
            }
            consumer.accept(new OutputFrame(OutputFrame.OutputType.STDOUT, ((String)line).getBytes()));
        }
        this.logString.append((String)lines.get(lines.size() - 1));
    }

    private String processAnsiColorCodes(String utf8String, Consumer<OutputFrame> consumer) {
        if (!(consumer instanceof BaseConsumer) || ((BaseConsumer)consumer).isRemoveColorCodes()) {
            return ANSI_COLOR_PATTERN.matcher(utf8String).replaceAll("");
        }
        return utf8String;
    }

    private byte[] merge(byte[] str1, byte[] str2) {
        byte[] mergedString = new byte[str1.length + str2.length];
        System.arraycopy(str1, 0, mergedString, 0, str1.length);
        System.arraycopy(str2, 0, mergedString, str1.length, str2.length);
        return mergedString;
    }
}

